/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.KernelStatement;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOnlyDatabaseKernelException;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementOperationParts;
import org.neo4j.kernel.api.Transactor;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.ReleaseLocksFailedKernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.TransactionForcefullyRolledBackException;
import org.neo4j.kernel.api.exceptions.TransactionalException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.operations.LegacyKernelOperations;
import org.neo4j.kernel.api.scan.LabelScanStore;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.LockHolder;
import org.neo4j.kernel.impl.api.LockHolderImpl;
import org.neo4j.kernel.impl.api.PersistenceCache;
import org.neo4j.kernel.impl.api.SchemaStorage;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.constraints.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.state.OldTxStateBridge;
import org.neo4j.kernel.impl.api.state.OldTxStateBridgeImpl;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.state.TxStateImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.LockManager;

public class KernelTransactionImplementation
implements KernelTransaction,
TxState.Holder {
    private final boolean readOnly;
    private final SchemaWriteGuard schemaWriteGuard;
    private final IndexingService indexService;
    private final LockHolder lockHolder;
    private final LabelScanStore labelScanStore;
    private final AbstractTransactionManager transactionManager;
    private final SchemaStorage schemaStorage;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final PersistenceCache persistenceCache;
    private final PersistenceManager persistenceManager;
    private final SchemaIndexProviderMap providerMap;
    private final UpdateableSchemaState schemaState;
    private final OldTxStateBridge legacyStateBridge;
    private final LegacyKernelOperations legacyKernelOperations;
    private final StatementOperationParts operations;
    private TransactionType transactionType = TransactionType.ANY;
    private boolean closing;
    private boolean closed;
    private TxStateImpl txState;
    private KernelStatement currentStatement;

    public KernelTransactionImplementation(StatementOperationParts operations, LegacyKernelOperations legacyKernelOperations, boolean readOnly, SchemaWriteGuard schemaWriteGuard, LabelScanStore labelScanStore, IndexingService indexService, LockManager lockManager, AbstractTransactionManager transactionManager, NodeManager nodeManager, PersistenceCache persistenceCache, UpdateableSchemaState schemaState, PersistenceManager persistenceManager, SchemaIndexProviderMap providerMap, NeoStore neoStore) {
        this.operations = operations;
        this.legacyKernelOperations = legacyKernelOperations;
        this.readOnly = readOnly;
        this.schemaWriteGuard = schemaWriteGuard;
        this.labelScanStore = labelScanStore;
        this.indexService = indexService;
        this.transactionManager = transactionManager;
        this.providerMap = providerMap;
        this.persistenceCache = persistenceCache;
        this.schemaState = schemaState;
        this.persistenceManager = persistenceManager;
        try {
            this.lockHolder = new LockHolderImpl(lockManager, transactionManager.getTransaction(), nodeManager);
        }
        catch (SystemException e) {
            throw new org.neo4j.graphdb.TransactionFailureException("Unable to get transaction", e);
        }
        this.constraintIndexCreator = new ConstraintIndexCreator(new Transactor(transactionManager), this.indexService);
        this.schemaStorage = new SchemaStorage(neoStore.getSchemaStore());
        this.legacyStateBridge = new OldTxStateBridgeImpl(nodeManager, transactionManager.getTransactionState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws TransactionFailureException {
        this.beginClose();
        try {
            try {
                boolean success = false;
                try {
                    try {
                        this.createTransactionCommands();
                    }
                    catch (RuntimeException e) {
                        this.transactionManager.rollback();
                        throw new TransactionForcefullyRolledBackException(e);
                    }
                    this.transactionManager.commit();
                    success = true;
                }
                finally {
                    if (!success) {
                        this.dropCreatedConstraintIndexes();
                    }
                }
                if (this.hasTxStateWithChanges()) {
                    this.persistenceCache.apply(this.txState());
                }
            }
            catch (HeuristicMixedException e) {
                throw new TransactionFailureException(e);
            }
            catch (HeuristicRollbackException e) {
                throw new TransactionFailureException(e);
            }
            catch (RollbackException e) {
                throw new TransactionFailureException(e);
            }
            catch (SystemException e) {
                throw new TransactionFailureException(e);
            }
            finally {
                try {
                    this.lockHolder.releaseLocks();
                }
                catch (ReleaseLocksFailedKernelException e) {
                    throw new TransactionFailureException(new RuntimeException(e.getMessage(), e));
                }
            }
            this.close();
        }
        finally {
            this.closing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws TransactionFailureException {
        this.beginClose();
        try {
            try {
                try {
                    this.dropCreatedConstraintIndexes();
                }
                finally {
                    if (this.transactionManager.getTransaction() != null) {
                        this.transactionManager.rollback();
                    }
                }
            }
            catch (IllegalStateException e) {
                throw new TransactionFailureException(e);
            }
            catch (SecurityException e) {
                throw new TransactionFailureException(e);
            }
            catch (SystemException e) {
                throw new TransactionFailureException(e);
            }
            finally {
                try {
                    this.lockHolder.releaseLocks();
                }
                catch (ReleaseLocksFailedKernelException e) {
                    throw new TransactionFailureException(Exceptions.withCause(new RollbackException(e.getMessage()), e));
                }
            }
            this.close();
        }
        finally {
            this.closing = false;
        }
    }

    @Override
    public KernelStatement acquireStatement() {
        this.assertOpen();
        if (this.currentStatement == null) {
            this.currentStatement = new KernelStatement(this, new IndexReaderFactory.Caching(this.indexService), this.labelScanStore, this, this.lockHolder, this.legacyKernelOperations, this.operations);
        }
        this.currentStatement.acquire();
        return this.currentStatement;
    }

    public void releaseStatement(Statement statement) {
        assert (this.currentStatement == statement);
        this.currentStatement = null;
    }

    public void upgradeToDataTransaction() throws InvalidTransactionTypeKernelException, ReadOnlyDatabaseKernelException {
        this.assertDatabaseWritable();
        this.transactionType = this.transactionType.upgradeToDataTransaction();
    }

    public void upgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException, ReadOnlyDatabaseKernelException {
        this.doUpgradeToSchemaTransaction();
        this.transactionType = this.transactionType.upgradeToSchemaTransaction();
    }

    public void doUpgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException, ReadOnlyDatabaseKernelException {
        this.assertDatabaseWritable();
        this.schemaWriteGuard.assertSchemaWritesAllowed();
    }

    private void assertDatabaseWritable() throws ReadOnlyDatabaseKernelException {
        if (this.readOnly) {
            throw new ReadOnlyDatabaseKernelException();
        }
    }

    public void assertTokenWriteAllowed() throws ReadOnlyDatabaseKernelException {
        this.assertDatabaseWritable();
    }

    private void dropCreatedConstraintIndexes() throws TransactionFailureException {
        if (this.hasTxStateWithChanges()) {
            for (IndexDescriptor createdConstraintIndex : this.txState().constraintIndexesCreatedInTx()) {
                try {
                    this.constraintIndexCreator.dropUniquenessConstraintIndex(createdConstraintIndex);
                }
                catch (DropIndexFailureException e) {
                    throw new IllegalStateException("Constraint index that was created in a transaction should be possible to drop during rollback of that transaction.", e);
                }
                catch (TransactionFailureException e) {
                    throw e;
                }
                catch (TransactionalException e) {
                    throw new IllegalStateException("The transaction manager could not fulfill the transaction for dropping the constraint.", e);
                }
            }
        }
    }

    @Override
    public TxState txState() {
        if (!this.hasTxState()) {
            this.txState = new TxStateImpl(this.legacyStateBridge, this.persistenceManager, null);
        }
        return this.txState;
    }

    @Override
    public boolean hasTxState() {
        return null != this.txState;
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.legacyStateBridge.hasChanges() || this.hasTxState() && this.txState.hasChanges();
    }

    private void close() {
        this.assertOpen();
        this.closed = true;
        if (this.currentStatement != null) {
            this.currentStatement.forceClose();
            this.currentStatement = null;
        }
    }

    private void beginClose() {
        this.assertOpen();
        if (this.closing) {
            throw new IllegalStateException("This transaction is already being closed.");
        }
        if (this.currentStatement != null) {
            this.currentStatement.forceClose();
            this.currentStatement = null;
        }
        this.closing = true;
    }

    private void createTransactionCommands() {
        if (this.hasTxStateWithChanges()) {
            final AtomicBoolean clearState = new AtomicBoolean(false);
            this.txState().accept(new TxState.Visitor(){

                @Override
                public void visitNodeLabelChanges(long id, Set<Integer> added, Set<Integer> removed) {
                }

                @Override
                public void visitAddedIndex(IndexDescriptor element, boolean isConstraintIndex) {
                    SchemaIndexProvider.Descriptor providerDescriptor = KernelTransactionImplementation.this.providerMap.getDefaultProvider().getProviderDescriptor();
                    IndexRule rule = isConstraintIndex ? IndexRule.constraintIndexRule(KernelTransactionImplementation.this.schemaStorage.newRuleId(), element.getLabelId(), element.getPropertyKeyId(), providerDescriptor, null) : IndexRule.indexRule(KernelTransactionImplementation.this.schemaStorage.newRuleId(), element.getLabelId(), element.getPropertyKeyId(), providerDescriptor);
                    KernelTransactionImplementation.this.persistenceManager.createSchemaRule(rule);
                }

                @Override
                public void visitRemovedIndex(IndexDescriptor element, boolean isConstraintIndex) {
                    try {
                        IndexRule rule = KernelTransactionImplementation.this.schemaStorage.indexRule(element.getLabelId(), element.getPropertyKeyId());
                        KernelTransactionImplementation.this.persistenceManager.dropSchemaRule(rule);
                    }
                    catch (SchemaRuleNotFoundException e) {
                        throw new ThisShouldNotHappenError("Tobias Lindaaker", "Index to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
                    }
                }

                @Override
                public void visitAddedConstraint(UniquenessConstraint element) {
                    IndexRule indexRule;
                    clearState.set(true);
                    long constraintId = KernelTransactionImplementation.this.schemaStorage.newRuleId();
                    try {
                        indexRule = KernelTransactionImplementation.this.schemaStorage.indexRule(element.label(), element.propertyKeyId());
                    }
                    catch (SchemaRuleNotFoundException e) {
                        throw new ThisShouldNotHappenError("Jacob Hansson", "Index is always created for the constraint before this point.");
                    }
                    KernelTransactionImplementation.this.persistenceManager.createSchemaRule(UniquenessConstraintRule.uniquenessConstraintRule(constraintId, element.label(), element.propertyKeyId(), indexRule.getId()));
                    KernelTransactionImplementation.this.persistenceManager.setConstraintIndexOwner(indexRule, constraintId);
                }

                @Override
                public void visitRemovedConstraint(UniquenessConstraint element) {
                    try {
                        clearState.set(true);
                        UniquenessConstraintRule rule = KernelTransactionImplementation.this.schemaStorage.uniquenessConstraint(element.label(), element.propertyKeyId());
                        KernelTransactionImplementation.this.persistenceManager.dropSchemaRule(rule);
                    }
                    catch (SchemaRuleNotFoundException e) {
                        throw new ThisShouldNotHappenError("Tobias Lindaaker", "Constraint to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
                    }
                    this.visitRemovedIndex(new IndexDescriptor(element.label(), element.propertyKeyId()), true);
                }
            });
            if (clearState.get()) {
                this.schemaState.clear();
            }
        }
    }

    private void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("This transaction has already been completed.");
        }
    }

    private static enum TransactionType {
        ANY,
        DATA{

            @Override
            TransactionType upgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException {
                throw new InvalidTransactionTypeKernelException("Cannot perform schema updates in a transaction that has performed data updates.");
            }
        }
        ,
        SCHEMA{

            @Override
            TransactionType upgradeToDataTransaction() throws InvalidTransactionTypeKernelException {
                throw new InvalidTransactionTypeKernelException("Cannot perform data updates in a transaction that has performed schema updates.");
            }
        };


        TransactionType upgradeToDataTransaction() throws InvalidTransactionTypeKernelException {
            return DATA;
        }

        TransactionType upgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException {
            return SCHEMA;
        }
    }
}

