/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Expander;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.BranchCollisionDetector;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.InitialStateFactory;
import org.neo4j.graphdb.traversal.SideSelectorPolicy;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.CommonBranchOrdering;
import org.neo4j.kernel.PathDescription;
import org.neo4j.kernel.ShortestPathsBranchCollisionDetector;
import org.neo4j.kernel.SideSelectorPolicies;
import org.neo4j.kernel.StandardExpander;
import org.neo4j.kernel.impl.traversal.BidirectionalTraversalDescriptionImpl;
import org.neo4j.kernel.impl.traversal.TraversalDescriptionImpl;

@Deprecated
public class Traversal {
    @Deprecated
    public static TraversalDescription description() {
        return new TraversalDescriptionImpl();
    }

    @Deprecated
    public static TraversalDescription traversal() {
        return new TraversalDescriptionImpl();
    }

    @Deprecated
    public static TraversalDescription traversal(UniquenessFactory uniqueness) {
        return new TraversalDescriptionImpl().uniqueness(uniqueness);
    }

    @Deprecated
    public static TraversalDescription traversal(UniquenessFactory uniqueness, Object optionalUniquenessParameter) {
        return new TraversalDescriptionImpl().uniqueness(uniqueness, optionalUniquenessParameter);
    }

    @Deprecated
    public static BidirectionalTraversalDescription bidirectionalTraversal() {
        return new BidirectionalTraversalDescriptionImpl();
    }

    @Deprecated
    public static <STATE> InitialStateFactory<STATE> initialState(final STATE initialState) {
        return new InitialStateFactory<STATE>(){

            @Override
            public STATE initialState(Path branch) {
                return initialState;
            }
        };
    }

    @Deprecated
    public static Expander expanderForTypes(RelationshipType type, Direction dir) {
        return StandardExpander.create(type, dir);
    }

    @Deprecated
    public static <STATE> PathExpander<STATE> pathExpanderForTypes(RelationshipType type, Direction dir) {
        return StandardExpander.create(type, dir);
    }

    @Deprecated
    public static Expander expanderForTypes(RelationshipType type) {
        return StandardExpander.create(type, Direction.BOTH);
    }

    @Deprecated
    public static <STATE> PathExpander<STATE> pathExpanderForTypes(RelationshipType type) {
        return StandardExpander.create(type, Direction.BOTH);
    }

    @Deprecated
    public static Expander emptyExpander() {
        return StandardExpander.DEFAULT;
    }

    @Deprecated
    public static <STATE> PathExpander<STATE> emptyPathExpander() {
        return StandardExpander.DEFAULT;
    }

    @Deprecated
    public static Expander expanderForTypes(RelationshipType type1, Direction dir1, RelationshipType type2, Direction dir2) {
        return StandardExpander.create(type1, dir1, type2, dir2);
    }

    @Deprecated
    public static <STATE> PathExpander<STATE> pathExpanderForTypes(RelationshipType type1, Direction dir1, RelationshipType type2, Direction dir2) {
        return StandardExpander.create(type1, dir1, type2, dir2);
    }

    @Deprecated
    public static Expander expanderForTypes(RelationshipType type1, Direction dir1, RelationshipType type2, Direction dir2, Object ... more) {
        return StandardExpander.create(type1, dir1, type2, dir2, more);
    }

    @Deprecated
    public static <STATE> PathExpander<STATE> pathExpanderForTypes(RelationshipType type1, Direction dir1, RelationshipType type2, Direction dir2, Object ... more) {
        return StandardExpander.create(type1, dir1, type2, dir2, more);
    }

    @Deprecated
    public static Expander expanderForAllTypes() {
        return Traversal.expanderForAllTypes(Direction.BOTH);
    }

    @Deprecated
    public static <STATE> PathExpander<STATE> pathExpanderForAllTypes() {
        return Traversal.pathExpanderForAllTypes(Direction.BOTH);
    }

    @Deprecated
    public static Expander expanderForAllTypes(Direction direction) {
        return StandardExpander.create(direction);
    }

    @Deprecated
    public static <STATE> PathExpander<STATE> pathExpanderForAllTypes(Direction direction) {
        return StandardExpander.create(direction);
    }

    public static Expander expander(PathExpander expander) {
        if (expander instanceof Expander) {
            return (Expander)((Object)expander);
        }
        return StandardExpander.wrap(expander);
    }

    public static Expander expander(RelationshipExpander expander) {
        if (expander instanceof Expander) {
            return (Expander)expander;
        }
        return StandardExpander.wrap(expander);
    }

    @Deprecated
    public static BranchOrderingPolicy preorderDepthFirst() {
        return CommonBranchOrdering.PREORDER_DEPTH_FIRST;
    }

    @Deprecated
    public static BranchOrderingPolicy postorderDepthFirst() {
        return CommonBranchOrdering.POSTORDER_DEPTH_FIRST;
    }

    @Deprecated
    public static BranchOrderingPolicy preorderBreadthFirst() {
        return CommonBranchOrdering.PREORDER_BREADTH_FIRST;
    }

    @Deprecated
    public static BranchOrderingPolicy postorderBreadthFirst() {
        return CommonBranchOrdering.POSTORDER_BREADTH_FIRST;
    }

    @Deprecated
    public static SideSelectorPolicy alternatingSelectorOrdering() {
        return SideSelectorPolicies.ALTERNATING;
    }

    @Deprecated
    public static SideSelectorPolicy levelSelectorOrdering() {
        return SideSelectorPolicies.LEVEL;
    }

    @Deprecated
    public static BranchCollisionDetector shortestPathsCollisionDetector(int maxDepth) {
        return new ShortestPathsBranchCollisionDetector(Evaluators.toDepth(maxDepth));
    }

    public static <T extends Path> String pathToString(T path, PathDescriptor<T> builder) {
        Node current = path.startNode();
        StringBuilder result = new StringBuilder();
        for (Relationship rel : path.relationships()) {
            result.append(builder.nodeRepresentation(path, current));
            result.append(builder.relationshipRepresentation(path, current, rel));
            current = rel.getOtherNode(current);
        }
        result.append(builder.nodeRepresentation(path, current));
        return result.toString();
    }

    public static String defaultPathToString(Path path) {
        return Traversal.pathToString(path, new DefaultPathDescriptor());
    }

    public static String simplePathToString(Path path) {
        return Traversal.pathToString(path, new DefaultPathDescriptor<Path>(){

            @Override
            public String relationshipRepresentation(Path path, Node from, Relationship relationship) {
                return relationship.getStartNode().equals(from) ? "-->" : "<--";
            }
        });
    }

    public static String simplePathToString(Path path, final String nodePropertyKey) {
        return Traversal.pathToString(path, new DefaultPathDescriptor<Path>(){

            @Override
            public String nodeRepresentation(Path path, Node node) {
                return "(" + node.getProperty(nodePropertyKey, node.getId()) + ")";
            }

            @Override
            public String relationshipRepresentation(Path path, Node from, Relationship relationship) {
                return relationship.getStartNode().equals(from) ? "-->" : "<--";
            }
        });
    }

    public static PathDescription path() {
        return new PathDescription();
    }

    public static class DefaultPathDescriptor<T extends Path>
    implements PathDescriptor<T> {
        @Override
        public String nodeRepresentation(Path path, Node node) {
            return "(" + node.getId() + ")";
        }

        @Override
        public String relationshipRepresentation(Path path, Node from, Relationship relationship) {
            String prefix = "--";
            String suffix = "--";
            if (from.equals(relationship.getEndNode())) {
                prefix = "<--";
            } else {
                suffix = "-->";
            }
            return prefix + "[" + relationship.getType().name() + "," + relationship.getId() + "]" + suffix;
        }
    }

    public static interface PathDescriptor<T extends Path> {
        public String nodeRepresentation(T var1, Node var2);

        public String relationshipRepresentation(T var1, Node var2, Relationship var3);
    }
}

