/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class ThreadToStatementContextBridge
extends LifecycleAdapter {
    protected final KernelAPI kernelAPI;
    private final AbstractTransactionManager txManager;
    private boolean isShutdown = false;

    public ThreadToStatementContextBridge(KernelAPI kernelAPI, AbstractTransactionManager txManager) {
        this.kernelAPI = kernelAPI;
        this.txManager = txManager;
    }

    public Statement statement() {
        return this.transaction().acquireStatement();
    }

    private KernelTransaction transaction() {
        this.checkIfShutdown();
        KernelTransaction transaction = this.txManager.getKernelTransaction();
        if (transaction == null) {
            throw new NotInTransactionException();
        }
        return transaction;
    }

    @Override
    public void shutdown() throws Throwable {
        this.isShutdown = true;
    }

    private void checkIfShutdown() {
        if (this.isShutdown) {
            throw new DatabaseShutdownException();
        }
    }

    public void assertInTransaction() {
        this.txManager.assertInTransaction();
    }
}

