/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.StandardExpander;

public class PathExpanderBuilder<STATE> {
    private final StandardExpander expander;

    public static <STATE> PathExpanderBuilder<STATE> empty() {
        return new PathExpanderBuilder<STATE>(StandardExpander.EMPTY);
    }

    public static <STATE> PathExpanderBuilder<STATE> allTypesAndDirections() {
        return new PathExpanderBuilder<STATE>(StandardExpander.DEFAULT);
    }

    public static <STATE> PathExpanderBuilder<STATE> allTypes(Direction direction) {
        return new PathExpanderBuilder<STATE>(StandardExpander.create(direction));
    }

    public PathExpanderBuilder<STATE> add(RelationshipType type) {
        return this.add(type, Direction.BOTH);
    }

    public PathExpanderBuilder<STATE> add(RelationshipType type, Direction direction) {
        return new PathExpanderBuilder<STATE>(this.expander.add(type, direction));
    }

    public PathExpanderBuilder<STATE> remove(RelationshipType type) {
        return new PathExpanderBuilder<STATE>(this.expander.remove(type));
    }

    public PathExpander<STATE> build() {
        return this.expander;
    }

    private PathExpanderBuilder(StandardExpander expander) {
        this.expander = expander;
    }
}

