/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.DataStatement;
import org.neo4j.kernel.api.ReadStatement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.SafeProperty;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.TokenNotFoundException;

public class RelationshipProxy
implements Relationship {
    private final long relId;
    private final RelationshipLookups relationshipLookups;
    private final ThreadToStatementContextBridge statementCtxProvider;

    RelationshipProxy(long relId, RelationshipLookups relationshipLookups, ThreadToStatementContextBridge statementCtxProvider) {
        this.relId = relId;
        this.relationshipLookups = relationshipLookups;
        this.statementCtxProvider = statementCtxProvider;
    }

    @Override
    public long getId() {
        return this.relId;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.relationshipLookups.getGraphDatabaseService();
    }

    @Override
    public void delete() {
        try (DataStatement statement = this.statementCtxProvider.dataStatement();){
            statement.relationshipDelete(this.getId());
        }
    }

    @Override
    public Node[] getNodes() {
        this.assertInTransaction();
        RelationshipImpl relationship = this.relationshipLookups.lookupRelationship(this.relId);
        return new Node[]{this.relationshipLookups.newNodeProxy(relationship.getStartNodeId()), this.relationshipLookups.newNodeProxy(relationship.getEndNodeId())};
    }

    @Override
    public Node getOtherNode(Node node) {
        this.assertInTransaction();
        RelationshipImpl relationship = this.relationshipLookups.lookupRelationship(this.relId);
        if (relationship.getStartNodeId() == node.getId()) {
            return this.relationshipLookups.newNodeProxy(relationship.getEndNodeId());
        }
        if (relationship.getEndNodeId() == node.getId()) {
            return this.relationshipLookups.newNodeProxy(relationship.getStartNodeId());
        }
        throw new NotFoundException("Node[" + node.getId() + "] not connected to this relationship[" + this.getId() + "]");
    }

    @Override
    public Node getStartNode() {
        this.assertInTransaction();
        return this.relationshipLookups.newNodeProxy(this.relationshipLookups.lookupRelationship(this.relId).getStartNodeId());
    }

    @Override
    public Node getEndNode() {
        this.assertInTransaction();
        return this.relationshipLookups.newNodeProxy(this.relationshipLookups.lookupRelationship(this.relId).getEndNodeId());
    }

    @Override
    public RelationshipType getType() {
        this.assertInTransaction();
        try {
            return this.relationshipLookups.getNodeManager().getRelationshipTypeById(this.relationshipLookups.lookupRelationship(this.relId).getTypeId());
        }
        catch (TokenNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<String> getPropertyKeys() {
        try (ReadStatement statement = this.statementCtxProvider.readStatement();){
            ArrayList<String> keys = new ArrayList<String>();
            Iterator<SafeProperty> properties = statement.relationshipGetAllProperties(this.getId());
            while (properties.hasNext()) {
                keys.add(statement.propertyKeyGetName(properties.next().propertyKeyId()));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Relationship not found", e);
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new ThisShouldNotHappenError("Jake", "Property key retrieved through kernel API should exist.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<Object> getPropertyValues() {
        try (ReadStatement statement = this.statementCtxProvider.readStatement();){
            Set<Object> set = IteratorUtil.asSet(Iterables.map(new Function<SafeProperty, Object>(){

                @Override
                public Object apply(SafeProperty prop) {
                    return prop.value();
                }
            }, statement.relationshipGetAllProperties(this.getId())));
            return set;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Relationship has been deleted", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getProperty(String key) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        try (ReadStatement statement = this.statementCtxProvider.readStatement();){
            long propertyId = statement.propertyKeyGetForName(key);
            if (propertyId == -1L) {
                throw new NotFoundException(String.format("No such property, '%s'.", key));
            }
            Object object = statement.relationshipGetProperty(this.relId, propertyId).value();
            return object;
        }
        catch (EntityNotFoundException | PropertyNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        try (ReadStatement statement = this.statementCtxProvider.readStatement();){
            long propertyId = statement.propertyKeyGetForName(key);
            Object object = statement.relationshipGetProperty(this.relId, propertyId).value(defaultValue);
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        try (ReadStatement statement = this.statementCtxProvider.readStatement();){
            long propertyId = statement.propertyKeyGetForName(key);
            boolean bl = propertyId != -1L && statement.relationshipGetProperty(this.relId, propertyId).isDefined();
            return bl;
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setProperty(String key, Object value) {
        boolean success = false;
        try (DataStatement statement = this.statementCtxProvider.dataStatement();){
            long propertyKeyId = statement.propertyKeyGetOrCreateForName(key);
            statement.relationshipSetProperty(this.relId, Property.property(propertyKeyId, value));
            success = true;
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (!success) {
                this.relationshipLookups.getNodeManager().setRollbackOnly();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object removeProperty(String key) {
        try (DataStatement statement = this.statementCtxProvider.dataStatement();){
            long propertyId = statement.propertyKeyGetOrCreateForName(key);
            Object object = statement.relationshipRemoveProperty(this.relId, propertyId).value(null);
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean isType(RelationshipType type) {
        this.assertInTransaction();
        try {
            return this.relationshipLookups.getNodeManager().getRelationshipTypeById(this.relationshipLookups.lookupRelationship(this.relId).getTypeId()).name().equals(type.name());
        }
        catch (TokenNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    public int compareTo(Object rel) {
        long theirId;
        Relationship r = (Relationship)rel;
        long ourId = this.getId();
        if (ourId < (theirId = r.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof Relationship && this.getId() == ((Relationship)o).getId();
    }

    public int hashCode() {
        return (int)(this.relId >>> 32 ^ this.relId);
    }

    public String toString() {
        return "Relationship[" + this.getId() + "]";
    }

    private void assertInTransaction() {
        this.statementCtxProvider.assertInTransaction();
    }

    public static interface RelationshipLookups {
        public Node newNodeProxy(long var1);

        public RelationshipImpl lookupRelationship(long var1);

        public GraphDatabaseService getGraphDatabaseService();

        public NodeManager getNodeManager();
    }
}

