/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.index.DuplicateIndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PreexistingIndexEntryConflictException;
import org.neo4j.kernel.impl.api.DiffSets;

public class PropertyUpdateUniquenessValidator {
    private PropertyUpdateUniquenessValidator() {
    }

    public static void validateUniqueness(Iterable<NodePropertyUpdate> updates, Lookup lookup) throws IndexEntryConflictException, IOException {
        HashMap<Object, DiffSets<Long>> referenceCount = new HashMap<Object, DiffSets<Long>>();
        block5: for (NodePropertyUpdate nodePropertyUpdate : updates) {
            switch (nodePropertyUpdate.getUpdateMode()) {
                case ADDED: {
                    PropertyUpdateUniquenessValidator.propertyValueDiffSet(referenceCount, nodePropertyUpdate.getValueAfter()).add(nodePropertyUpdate.getNodeId());
                    continue block5;
                }
                case CHANGED: {
                    PropertyUpdateUniquenessValidator.propertyValueDiffSet(referenceCount, nodePropertyUpdate.getValueBefore()).remove(nodePropertyUpdate.getNodeId());
                    PropertyUpdateUniquenessValidator.propertyValueDiffSet(referenceCount, nodePropertyUpdate.getValueAfter()).add(nodePropertyUpdate.getNodeId());
                    continue block5;
                }
                case REMOVED: {
                    PropertyUpdateUniquenessValidator.propertyValueDiffSet(referenceCount, nodePropertyUpdate.getValueBefore()).remove(nodePropertyUpdate.getNodeId());
                    continue block5;
                }
            }
            throw new UnsupportedOperationException();
        }
        for (Map.Entry entry : referenceCount.entrySet()) {
            Object value = entry.getKey();
            int delta = ((DiffSets)entry.getValue()).delta();
            if (delta > 1) {
                throw new DuplicateIndexEntryConflictException(value, IteratorUtil.asSet(((DiffSets)entry.getValue()).getAdded()));
            }
            if (delta != 1) continue;
            Long addedNode = (Long)Iterables.single(((DiffSets)entry.getValue()).getAdded());
            Long existingNode = lookup.currentlyIndexedNode(value);
            if (existingNode == null || addedNode.equals(existingNode)) continue;
            throw new PreexistingIndexEntryConflictException(value, existingNode, addedNode);
        }
    }

    private static DiffSets<Long> propertyValueDiffSet(Map<Object, DiffSets<Long>> referenceCount, Object value) {
        DiffSets<Long> diffSets = referenceCount.get(value);
        if (diffSets == null) {
            diffSets = new DiffSets();
            referenceCount.put(value, diffSets);
        }
        return diffSets;
    }

    public static interface Lookup {
        public Long currentlyIndexedNode(Object var1) throws IOException;
    }
}

