/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.AddIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.operations.EntityWriteOperations;
import org.neo4j.kernel.api.operations.SchemaReadOperations;
import org.neo4j.kernel.api.operations.SchemaStateOperations;
import org.neo4j.kernel.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.SafeProperty;
import org.neo4j.kernel.impl.api.constraints.ConstraintValidationKernelException;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;

public class LockingStatementOperations
implements EntityWriteOperations,
SchemaReadOperations,
SchemaWriteOperations,
SchemaStateOperations {
    private final EntityWriteOperations entityWriteDelegate;
    private final SchemaReadOperations schemaReadDelegate;
    private final SchemaWriteOperations schemaWriteDelegate;
    private final SchemaStateOperations schemaStateDelegate;

    public LockingStatementOperations(EntityWriteOperations entityWriteDelegate, SchemaReadOperations schemaReadDelegate, SchemaWriteOperations schemaWriteDelegate, SchemaStateOperations schemaStateDelegate) {
        this.entityWriteDelegate = entityWriteDelegate;
        this.schemaReadDelegate = schemaReadDelegate;
        this.schemaWriteDelegate = schemaWriteDelegate;
        this.schemaStateDelegate = schemaStateDelegate;
    }

    @Override
    public boolean nodeAddLabel(Statement state, long nodeId, long labelId) throws EntityNotFoundException, ConstraintValidationKernelException {
        state.locks().acquireNodeWriteLock(nodeId);
        return this.entityWriteDelegate.nodeAddLabel(state, nodeId, labelId);
    }

    @Override
    public boolean nodeRemoveLabel(Statement state, long nodeId, long labelId) throws EntityNotFoundException {
        state.locks().acquireNodeWriteLock(nodeId);
        return this.entityWriteDelegate.nodeRemoveLabel(state, nodeId, labelId);
    }

    @Override
    public IndexDescriptor indexCreate(Statement state, long labelId, long propertyKey) throws AddIndexFailureException, AlreadyIndexedException, AlreadyConstrainedException {
        state.locks().acquireSchemaWriteLock();
        return this.schemaWriteDelegate.indexCreate(state, labelId, propertyKey);
    }

    @Override
    public void indexDrop(Statement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        state.locks().acquireSchemaWriteLock();
        this.schemaWriteDelegate.indexDrop(state, descriptor);
    }

    @Override
    public void uniqueIndexDrop(Statement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        state.locks().acquireSchemaWriteLock();
        this.schemaWriteDelegate.uniqueIndexDrop(state, descriptor);
    }

    @Override
    public <K, V> V schemaStateGetOrCreate(Statement state, K key, Function<K, V> creator) {
        state.locks().acquireSchemaReadLock();
        return this.schemaStateDelegate.schemaStateGetOrCreate(state, key, creator);
    }

    @Override
    public <K> boolean schemaStateContains(Statement state, K key) {
        state.locks().acquireSchemaReadLock();
        return this.schemaStateDelegate.schemaStateContains(state, key);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(Statement state, long labelId) {
        state.locks().acquireSchemaReadLock();
        return this.schemaReadDelegate.indexesGetForLabel(state, labelId);
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(Statement state, long labelId, long propertyKey) throws SchemaRuleNotFoundException {
        state.locks().acquireSchemaReadLock();
        return this.schemaReadDelegate.indexesGetForLabelAndPropertyKey(state, labelId, propertyKey);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(Statement state) {
        state.locks().acquireSchemaReadLock();
        return this.schemaReadDelegate.indexesGetAll(state);
    }

    @Override
    public InternalIndexState indexGetState(Statement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        state.locks().acquireSchemaReadLock();
        return this.schemaReadDelegate.indexGetState(state, descriptor);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(Statement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        state.locks().acquireSchemaReadLock();
        return this.schemaReadDelegate.indexGetOwningUniquenessConstraintId(state, index);
    }

    @Override
    public long indexGetCommittedId(Statement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        state.locks().acquireSchemaReadLock();
        return this.schemaReadDelegate.indexGetCommittedId(state, index);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(Statement state, long labelId) {
        state.locks().acquireSchemaReadLock();
        return this.schemaReadDelegate.uniqueIndexesGetForLabel(state, labelId);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll(Statement state) {
        state.locks().acquireSchemaReadLock();
        return this.schemaReadDelegate.uniqueIndexesGetAll(state);
    }

    @Override
    public void nodeDelete(Statement state, long nodeId) {
        state.locks().acquireNodeWriteLock(nodeId);
        this.entityWriteDelegate.nodeDelete(state, nodeId);
    }

    @Override
    public void relationshipDelete(Statement state, long relationshipId) {
        state.locks().acquireRelationshipWriteLock(relationshipId);
        this.entityWriteDelegate.relationshipDelete(state, relationshipId);
    }

    @Override
    public UniquenessConstraint uniquenessConstraintCreate(Statement state, long labelId, long propertyKeyId) throws CreateConstraintFailureException, AlreadyConstrainedException, AlreadyIndexedException {
        state.locks().acquireSchemaWriteLock();
        return this.schemaWriteDelegate.uniquenessConstraintCreate(state, labelId, propertyKeyId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(Statement state, long labelId, long propertyKeyId) {
        state.locks().acquireSchemaReadLock();
        return this.schemaReadDelegate.constraintsGetForLabelAndPropertyKey(state, labelId, propertyKeyId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(Statement state, long labelId) {
        state.locks().acquireSchemaReadLock();
        return this.schemaReadDelegate.constraintsGetForLabel(state, labelId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll(Statement state) {
        state.locks().acquireSchemaReadLock();
        return this.schemaReadDelegate.constraintsGetAll(state);
    }

    @Override
    public void constraintDrop(Statement state, UniquenessConstraint constraint) throws DropConstraintFailureException {
        state.locks().acquireSchemaWriteLock();
        this.schemaWriteDelegate.constraintDrop(state, constraint);
    }

    @Override
    public Property nodeSetProperty(Statement state, long nodeId, SafeProperty property) throws EntityNotFoundException, ConstraintValidationKernelException {
        state.locks().acquireNodeWriteLock(nodeId);
        return this.entityWriteDelegate.nodeSetProperty(state, nodeId, property);
    }

    @Override
    public Property nodeRemoveProperty(Statement state, long nodeId, long propertyKeyId) throws EntityNotFoundException {
        state.locks().acquireNodeWriteLock(nodeId);
        return this.entityWriteDelegate.nodeRemoveProperty(state, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipSetProperty(Statement state, long relationshipId, SafeProperty property) throws EntityNotFoundException {
        state.locks().acquireRelationshipWriteLock(relationshipId);
        return this.entityWriteDelegate.relationshipSetProperty(state, relationshipId, property);
    }

    @Override
    public Property relationshipRemoveProperty(Statement state, long relationshipId, long propertyKeyId) throws EntityNotFoundException {
        state.locks().acquireRelationshipWriteLock(relationshipId);
        return this.entityWriteDelegate.relationshipRemoveProperty(state, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphSetProperty(Statement state, SafeProperty property) {
        state.locks().acquireGraphWriteLock();
        return this.entityWriteDelegate.graphSetProperty(state, property);
    }

    @Override
    public Property graphRemoveProperty(Statement state, long propertyKeyId) {
        state.locks().acquireGraphWriteLock();
        return this.entityWriteDelegate.graphRemoveProperty(state, propertyKeyId);
    }

    @Override
    public String indexGetFailure(Statement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.schemaReadDelegate.indexGetFailure(state, descriptor);
    }
}

