/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionImplementation;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementOperationParts;
import org.neo4j.kernel.api.Transactor;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.ConstraintCreationException;
import org.neo4j.kernel.api.exceptions.TransactionalException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.operations.AuxiliaryStoreOperations;
import org.neo4j.kernel.api.operations.ConstraintEnforcingEntityWriteOperations;
import org.neo4j.kernel.api.operations.LegacyKernelOperations;
import org.neo4j.kernel.api.scan.LabelScanStore;
import org.neo4j.kernel.impl.api.CachingStatementOperations;
import org.neo4j.kernel.impl.api.DataIntegrityValidatingStatementOperations;
import org.neo4j.kernel.impl.api.DefaultLegacyKernelOperations;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.LegacyAutoIndexAuxStoreOps;
import org.neo4j.kernel.impl.api.LockHolder;
import org.neo4j.kernel.impl.api.LockHolderImpl;
import org.neo4j.kernel.impl.api.LockingStatementOperations;
import org.neo4j.kernel.impl.api.PersistenceCache;
import org.neo4j.kernel.impl.api.ReadOnlyStatementOperations;
import org.neo4j.kernel.impl.api.SchemaCache;
import org.neo4j.kernel.impl.api.SchemaStateConcern;
import org.neo4j.kernel.impl.api.SchemaStorage;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StoreStatementOperations;
import org.neo4j.kernel.impl.api.UniquenessConstraintStoppingStatementOperations;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.constraints.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.state.OldTxStateBridge;
import org.neo4j.kernel.impl.api.state.OldTxStateBridgeImpl;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.state.TxStateImpl;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.DataSourceRegistrationListener;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class Kernel
extends LifecycleAdapter
implements KernelAPI {
    private final boolean readOnly;
    private final AbstractTransactionManager transactionManager;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final RelationshipTypeTokenHolder relationshipTypeTokenHolder;
    private final PersistenceManager persistenceManager;
    private final XaDataSourceManager dataSourceManager;
    private final LockManager lockManager;
    private final DependencyResolver dependencyResolver;
    private final UpdateableSchemaState schemaState;
    private final boolean highlyAvailableInstance;
    private IndexingService indexService;
    private NeoStore neoStore;
    private NodeManager nodeManager;
    private PersistenceCache persistenceCache;
    private boolean isShutdown = false;
    private StatementOperationParts statementOperations;
    private StatementOperationParts readOnlyStatementOperations;
    private SchemaCache schemaCache;
    private SchemaIndexProviderMap providerMap = null;
    private LegacyKernelOperations legacyKernelOperations;
    private LegacyKernelOperations readOnlyLegacyKernelOperations;
    private LabelScanStore labelScanStore;

    public Kernel(boolean readOnly, AbstractTransactionManager transactionManager, PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, RelationshipTypeTokenHolder relationshipTypeTokenHolder, PersistenceManager persistenceManager, XaDataSourceManager dataSourceManager, LockManager lockManager, UpdateableSchemaState schemaState, DependencyResolver dependencyResolver, boolean highlyAvailable) {
        this.readOnly = readOnly;
        this.transactionManager = transactionManager;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
        this.relationshipTypeTokenHolder = relationshipTypeTokenHolder;
        this.persistenceManager = persistenceManager;
        this.dataSourceManager = dataSourceManager;
        this.lockManager = lockManager;
        this.dependencyResolver = dependencyResolver;
        this.schemaState = schemaState;
        this.highlyAvailableInstance = highlyAvailable;
    }

    @Override
    public void start() {
        this.nodeManager = this.dependencyResolver.resolveDependency(NodeManager.class);
        this.dataSourceManager.addDataSourceRegistrationListener(XaDataSourceManager.neoStoreListener(new DataSourceRegistrationListener(){

            @Override
            public void registeredDataSource(XaDataSource ds) {
                NeoStoreXaDataSource neoDataSource = (NeoStoreXaDataSource)ds;
                Kernel.this.neoStore = neoDataSource.getNeoStore();
                Kernel.this.indexService = neoDataSource.getIndexService();
                Kernel.this.labelScanStore = neoDataSource.getLabelScanStore();
                Kernel.this.providerMap = neoDataSource.getProviderMap();
                Kernel.this.persistenceCache = neoDataSource.getPersistenceCache();
                Kernel.this.schemaCache = neoDataSource.getSchemaCache();
                for (SchemaRule schemaRule : IteratorUtil.loop(Kernel.this.neoStore.getSchemaStore().loadAllSchemaRules())) {
                    Kernel.this.schemaCache.addSchemaRule(schemaRule);
                }
            }

            @Override
            public void unregisteredDataSource(XaDataSource ds) {
                Kernel.this.neoStore = null;
            }
        }));
    }

    @Override
    public void bootstrapAfterRecovery() {
        StatementOperationParts parts;
        this.statementOperations = parts = this.buildStatementOperations();
        this.legacyKernelOperations = new DefaultLegacyKernelOperations(this.nodeManager);
        ReadOnlyStatementOperations readOnlyParts = new ReadOnlyStatementOperations(parts.keyReadOperations(), parts.schemaStateOperations());
        this.readOnlyStatementOperations = parts.override(parts.keyReadOperations(), readOnlyParts, parts.entityReadOperations(), readOnlyParts, parts.schemaReadOperations(), readOnlyParts, readOnlyParts, new Object[0]);
        this.readOnlyLegacyKernelOperations = readOnlyParts;
    }

    @Override
    public void stop() {
        this.isShutdown = true;
    }

    @Override
    public KernelTransaction newTransaction() {
        this.checkIfShutdown();
        if (this.readOnly) {
            return new TransactionImplementation(this.readOnlyStatementOperations, this.readOnlyLegacyKernelOperations);
        }
        return new TransactionImplementation(this.statementOperations, this.legacyKernelOperations);
    }

    private void checkIfShutdown() {
        if (this.isShutdown) {
            throw new DatabaseShutdownException();
        }
    }

    private StatementOperationParts buildStatementOperations() {
        StoreStatementOperations context = new StoreStatementOperations(this.propertyKeyTokenHolder, this.labelTokenHolder, this.relationshipTypeTokenHolder, new SchemaStorage(this.neoStore.getSchemaStore()), this.neoStore, this.persistenceManager, this.indexService);
        StatementOperationParts parts = new StatementOperationParts(context, context, context, context, context, null, null).additionalPart(AuxiliaryStoreOperations.class, context);
        CachingStatementOperations cachingContext = new CachingStatementOperations(parts.entityReadOperations(), parts.schemaReadOperations(), this.persistenceCache, this.schemaCache);
        parts = parts.override(null, null, cachingContext, null, cachingContext, null, null, new Object[0]);
        AuxiliaryStoreOperations auxStoreOperations = parts.resolve(AuxiliaryStoreOperations.class);
        auxStoreOperations = new LegacyAutoIndexAuxStoreOps(auxStoreOperations, this.propertyKeyTokenHolder, this.nodeManager.getNodePropertyTrackers(), this.nodeManager.getRelationshipPropertyTrackers(), this.nodeManager);
        StateHandlingStatementOperations stateHandlingContext = new StateHandlingStatementOperations(parts.entityReadOperations(), parts.schemaReadOperations(), auxStoreOperations, new ConstraintIndexCreator(new Transactor(this.transactionManager), this.indexService));
        parts = parts.override(null, null, stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, new SchemaStateConcern(this.schemaState), new Object[0]);
        ConstraintEnforcingEntityWriteOperations constraintEnforcingEntityWriteOperations = new ConstraintEnforcingEntityWriteOperations(parts.entityWriteOperations(), parts.entityReadOperations(), parts.schemaReadOperations());
        DataIntegrityValidatingStatementOperations dataIntegrityContext = new DataIntegrityValidatingStatementOperations(parts.keyWriteOperations(), parts.schemaReadOperations(), parts.schemaWriteOperations());
        parts = parts.override(null, dataIntegrityContext, null, constraintEnforcingEntityWriteOperations, null, dataIntegrityContext, null, new Object[0]);
        LockingStatementOperations lockingContext = new LockingStatementOperations(parts.entityWriteOperations(), parts.schemaReadOperations(), parts.schemaWriteOperations(), parts.schemaStateOperations());
        parts = parts.override(null, null, null, lockingContext, lockingContext, lockingContext, lockingContext, new Object[0]);
        if (this.highlyAvailableInstance) {
            UniquenessConstraintStoppingStatementOperations stoppingContext = new UniquenessConstraintStoppingStatementOperations(parts.schemaWriteOperations());
            parts = parts.override(null, null, null, null, null, stoppingContext, null, new Object[0]);
        }
        return parts;
    }

    class TransactionImplementation
    extends KernelTransactionImplementation
    implements TxState.Holder {
        private TxStateImpl txState;
        private final OldTxStateBridge legacyStateBridge;
        private final SchemaStorage schemaStorage;
        private final ConstraintIndexCreator constraintIndexCreator;
        private final LockHolder lockHolder;

        TransactionImplementation(StatementOperationParts operations, LegacyKernelOperations legacyKernelOperations) {
            super(operations, legacyKernelOperations);
            this.legacyStateBridge = new OldTxStateBridgeImpl(Kernel.this.nodeManager, Kernel.this.transactionManager.getTransactionState());
            this.schemaStorage = new SchemaStorage(Kernel.this.neoStore.getSchemaStore());
            this.constraintIndexCreator = new ConstraintIndexCreator(new Transactor(Kernel.this.transactionManager), Kernel.this.indexService);
            try {
                this.lockHolder = new LockHolderImpl(Kernel.this.lockManager, Kernel.this.transactionManager.getTransaction(), Kernel.this.nodeManager);
            }
            catch (SystemException e) {
                throw new TransactionFailureException("Unable to get transaction", e);
            }
        }

        @Override
        protected Statement newStatement() {
            return new Statement(new IndexReaderFactory.Caching(Kernel.this.indexService), Kernel.this.labelScanStore, this, this.lockHolder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doCommit() throws org.neo4j.kernel.api.exceptions.TransactionFailureException {
            try {
                boolean success = false;
                try {
                    this.createTransactionCommands();
                    Kernel.this.transactionManager.commit();
                    success = true;
                }
                finally {
                    if (!success) {
                        this.dropCreatedConstraintIndexes();
                    }
                }
                if (this.hasTxStateWithChanges()) {
                    Kernel.this.persistenceCache.apply(this.txState());
                }
            }
            catch (HeuristicMixedException e) {
                throw new org.neo4j.kernel.api.exceptions.TransactionFailureException(e);
            }
            catch (HeuristicRollbackException e) {
                throw new org.neo4j.kernel.api.exceptions.TransactionFailureException(e);
            }
            catch (RollbackException e) {
                throw new org.neo4j.kernel.api.exceptions.TransactionFailureException(e);
            }
            catch (SystemException e) {
                throw new org.neo4j.kernel.api.exceptions.TransactionFailureException(e);
            }
            finally {
                this.lockHolder.releaseLocks();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRollback() throws org.neo4j.kernel.api.exceptions.TransactionFailureException {
            try {
                try {
                    this.dropCreatedConstraintIndexes();
                }
                finally {
                    if (Kernel.this.transactionManager.getTransaction() != null) {
                        Kernel.this.transactionManager.rollback();
                    }
                }
            }
            catch (IllegalStateException e) {
                throw new org.neo4j.kernel.api.exceptions.TransactionFailureException(e);
            }
            catch (SecurityException e) {
                throw new org.neo4j.kernel.api.exceptions.TransactionFailureException(e);
            }
            catch (SystemException e) {
                throw new org.neo4j.kernel.api.exceptions.TransactionFailureException(e);
            }
            finally {
                this.lockHolder.releaseLocks();
            }
        }

        private void createTransactionCommands() {
            if (this.hasTxStateWithChanges()) {
                final AtomicBoolean clearState = new AtomicBoolean(false);
                this.txState().accept(new TxState.Visitor(){

                    @Override
                    public void visitNodeLabelChanges(long id, Set<Long> added, Set<Long> removed) {
                    }

                    @Override
                    public void visitAddedIndex(IndexDescriptor element, boolean isConstraintIndex) {
                        SchemaIndexProvider.Descriptor providerDescriptor = Kernel.this.providerMap.getDefaultProvider().getProviderDescriptor();
                        IndexRule rule = isConstraintIndex ? IndexRule.constraintIndexRule(TransactionImplementation.this.schemaStorage.newRuleId(), element.getLabelId(), element.getPropertyKeyId(), providerDescriptor, null) : IndexRule.indexRule(TransactionImplementation.this.schemaStorage.newRuleId(), element.getLabelId(), element.getPropertyKeyId(), providerDescriptor);
                        Kernel.this.persistenceManager.createSchemaRule(rule);
                    }

                    @Override
                    public void visitRemovedIndex(IndexDescriptor element, boolean isConstraintIndex) {
                        try {
                            IndexRule rule = TransactionImplementation.this.schemaStorage.indexRule(element.getLabelId(), element.getPropertyKeyId());
                            Kernel.this.persistenceManager.dropSchemaRule(rule.getId());
                        }
                        catch (SchemaRuleNotFoundException e) {
                            throw new ThisShouldNotHappenError("Tobias Lindaaker", "Index to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
                        }
                    }

                    @Override
                    public void visitAddedConstraint(UniquenessConstraint element, long indexId) {
                        try {
                            TransactionImplementation.this.constraintIndexCreator.validateConstraintIndex(element, indexId);
                        }
                        catch (CreateConstraintFailureException e) {
                            throw new ConstraintCreationException(e);
                        }
                        clearState.set(true);
                        long constraintId = TransactionImplementation.this.schemaStorage.newRuleId();
                        Kernel.this.persistenceManager.createSchemaRule(UniquenessConstraintRule.uniquenessConstraintRule(constraintId, element.label(), element.propertyKeyId(), indexId));
                        Kernel.this.persistenceManager.setConstraintIndexOwner(indexId, constraintId);
                    }

                    @Override
                    public void visitRemovedConstraint(UniquenessConstraint element) {
                        try {
                            clearState.set(true);
                            UniquenessConstraintRule rule = TransactionImplementation.this.schemaStorage.uniquenessConstraint(element.label(), element.propertyKeyId());
                            Kernel.this.persistenceManager.dropSchemaRule(rule.getId());
                        }
                        catch (SchemaRuleNotFoundException e) {
                            throw new ThisShouldNotHappenError("Tobias Lindaaker", "Constraint to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
                        }
                        this.visitRemovedIndex(new IndexDescriptor(element.label(), element.propertyKeyId()), true);
                    }
                });
                if (clearState.get()) {
                    Kernel.this.schemaState.clear();
                }
            }
        }

        private void dropCreatedConstraintIndexes() throws org.neo4j.kernel.api.exceptions.TransactionFailureException {
            if (this.hasTxStateWithChanges()) {
                for (IndexDescriptor createdConstraintIndex : this.txState().constraintIndexesCreatedInTx()) {
                    try {
                        this.constraintIndexCreator.dropUniquenessConstraintIndex(createdConstraintIndex);
                    }
                    catch (DropIndexFailureException e) {
                        throw new IllegalStateException("Constraint index that was created in a transaction should be possible to drop during rollback of that transaction.", e);
                    }
                    catch (org.neo4j.kernel.api.exceptions.TransactionFailureException e) {
                        throw e;
                    }
                    catch (TransactionalException e) {
                        throw new IllegalStateException("The transaction manager could not fulfill the transaction for dropping the constraint.", e);
                    }
                }
            }
        }

        @Override
        public TxState txState() {
            if (!this.hasTxState()) {
                this.txState = new TxStateImpl(this.legacyStateBridge, Kernel.this.persistenceManager, null);
            }
            return this.txState;
        }

        @Override
        public boolean hasTxState() {
            return null != this.txState;
        }

        @Override
        public boolean hasTxStateWithChanges() {
            return this.legacyStateBridge.hasChanges() || this.hasTxState() && this.txState.hasChanges();
        }
    }
}

