/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.concurrent.Callable;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.properties.BooleanArrayProperty;
import org.neo4j.kernel.api.properties.BooleanProperty;
import org.neo4j.kernel.api.properties.ByteArrayProperty;
import org.neo4j.kernel.api.properties.ByteProperty;
import org.neo4j.kernel.api.properties.CharArrayProperty;
import org.neo4j.kernel.api.properties.CharProperty;
import org.neo4j.kernel.api.properties.DoubleArrayProperty;
import org.neo4j.kernel.api.properties.DoubleProperty;
import org.neo4j.kernel.api.properties.FloatArrayProperty;
import org.neo4j.kernel.api.properties.FloatProperty;
import org.neo4j.kernel.api.properties.IntArrayProperty;
import org.neo4j.kernel.api.properties.IntProperty;
import org.neo4j.kernel.api.properties.LazyArrayProperty;
import org.neo4j.kernel.api.properties.LazyStringProperty;
import org.neo4j.kernel.api.properties.LongArrayProperty;
import org.neo4j.kernel.api.properties.NoProperty;
import org.neo4j.kernel.api.properties.PropertyConversion;
import org.neo4j.kernel.api.properties.SafeProperty;
import org.neo4j.kernel.api.properties.ShortArrayProperty;
import org.neo4j.kernel.api.properties.ShortProperty;
import org.neo4j.kernel.api.properties.StringArrayProperty;
import org.neo4j.kernel.api.properties.StringProperty;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;

public abstract class Property {
    public static Property noNodeProperty(long nodeId, long propertyKeyId) {
        return Property.noProperty(propertyKeyId, EntityType.NODE, nodeId);
    }

    public static Property noRelationshipProperty(long relationshipId, long propertyKeyId) {
        return Property.noProperty(propertyKeyId, EntityType.RELATIONSHIP, relationshipId);
    }

    public static Property noGraphProperty(long propertyKeyId) {
        return Property.noProperty(propertyKeyId, EntityType.GRAPH, -1L);
    }

    private static Property noProperty(long propertyKeyId, EntityType type, long entityId) {
        return new NoProperty(propertyKeyId, type, entityId);
    }

    public static Property propertyFromNode(long nodeId, long propertyKeyId, Object value) {
        return null == value ? Property.noNodeProperty(nodeId, propertyKeyId) : Property.property(propertyKeyId, value);
    }

    public static Property propertyFromRelationship(long relationshipId, long propertyKeyId, Object value) {
        return null == value ? Property.noRelationshipProperty(relationshipId, propertyKeyId) : Property.property(propertyKeyId, value);
    }

    public static SafeProperty property(long propertyKeyId, Object value) {
        return PropertyConversion.convertProperty(propertyKeyId, value);
    }

    public abstract long propertyKeyId();

    public abstract boolean valueEquals(Object var1);

    public abstract Object value() throws PropertyNotFoundException;

    public abstract Object value(Object var1);

    public abstract String stringValue() throws PropertyNotFoundException;

    public abstract String stringValue(String var1);

    public abstract String valueAsString() throws PropertyNotFoundException;

    public abstract Number numberValue() throws PropertyNotFoundException;

    public abstract Number numberValue(Number var1);

    public abstract int intValue() throws PropertyNotFoundException;

    public abstract int intValue(int var1);

    public abstract long longValue() throws PropertyNotFoundException;

    public abstract long longValue(long var1);

    public abstract boolean booleanValue() throws PropertyNotFoundException;

    public abstract boolean booleanValue(boolean var1);

    public static SafeProperty stringProperty(long propertyKeyId, String value) {
        return new StringProperty(propertyKeyId, value);
    }

    public static SafeProperty lazyStringProperty(long propertyKeyId, Callable<String> producer) {
        return new LazyStringProperty(propertyKeyId, producer);
    }

    public static SafeProperty lazyArrayProperty(long propertyKeyId, Callable<Object> producer) {
        return new LazyArrayProperty(propertyKeyId, producer);
    }

    public static SafeProperty longProperty(long propertyKeyId, long value) {
        return PropertyConversion.chooseLongPropertyType(propertyKeyId, value);
    }

    public static SafeProperty intProperty(long propertyKeyId, int value) {
        return new IntProperty(propertyKeyId, value);
    }

    public static SafeProperty shortProperty(long propertyKeyId, short value) {
        return new ShortProperty(propertyKeyId, value);
    }

    public static SafeProperty byteProperty(long propertyKeyId, byte value) {
        return new ByteProperty(propertyKeyId, value);
    }

    public static SafeProperty booleanProperty(long propertyKeyId, boolean value) {
        return new BooleanProperty(propertyKeyId, value);
    }

    public static SafeProperty charProperty(long propertyKeyId, char value) {
        return new CharProperty(propertyKeyId, value);
    }

    public static SafeProperty doubleProperty(long propertyKeyId, double value) {
        return new DoubleProperty(propertyKeyId, value);
    }

    public static SafeProperty floatProperty(long propertyKeyId, float value) {
        return new FloatProperty(propertyKeyId, value);
    }

    public static SafeProperty stringArrayProperty(long propertyKeyId, String[] value) {
        return new StringArrayProperty(propertyKeyId, value);
    }

    public static SafeProperty byteArrayProperty(long propertyKeyId, byte[] value) {
        return new ByteArrayProperty(propertyKeyId, value);
    }

    public static SafeProperty longArrayProperty(long propertyKeyId, long[] value) {
        return new LongArrayProperty(propertyKeyId, value);
    }

    public static SafeProperty intArrayProperty(long propertyKeyId, int[] value) {
        return new IntArrayProperty(propertyKeyId, value);
    }

    public static SafeProperty doubleArrayProperty(long propertyKeyId, double[] value) {
        return new DoubleArrayProperty(propertyKeyId, value);
    }

    public static SafeProperty floatArrayProperty(long propertyKeyId, float[] value) {
        return new FloatArrayProperty(propertyKeyId, value);
    }

    public static SafeProperty booleanArrayProperty(long propertyKeyId, boolean[] value) {
        return new BooleanArrayProperty(propertyKeyId, value);
    }

    public static SafeProperty charArrayProperty(long propertyKeyId, char[] value) {
        return new CharArrayProperty(propertyKeyId, value);
    }

    public static SafeProperty shortArrayProperty(long propertyKeyId, short[] value) {
        return new ShortArrayProperty(propertyKeyId, value);
    }

    Property() {
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract boolean isDefined();

    @Deprecated
    public abstract PropertyData asPropertyDataJustForIntegration();
}

