/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import java.util.concurrent.Callable;
import org.neo4j.kernel.api.properties.LazyProperty;

class LazyArrayProperty
extends LazyProperty<Object> {
    private Type type;

    LazyArrayProperty(long propertyKeyId, Callable<?> producer) {
        super(propertyKeyId, producer);
    }

    @Override
    protected Object produceValue() {
        Object value = super.produceValue();
        this.type = Type.from(value);
        return value;
    }

    @Override
    public boolean valueEquals(Object value) {
        Object myValue = this.value();
        return this.type.equals(myValue, value);
    }

    @Override
    int valueHash() {
        Object myValue = this.value();
        return this.type.hashCode(myValue);
    }

    @Override
    protected Object castAndPrepareForReturn(Object value) {
        return this.type.clone(value);
    }

    private static enum Type {
        INT{

            @Override
            int hashCode(Object array) {
                return Arrays.hashCode((int[])array);
            }

            @Override
            boolean equals(Object array1, Object array2) {
                return array2 instanceof int[] && Arrays.equals((int[])array1, (int[])array2);
            }

            @Override
            Object clone(Object array) {
                return ((int[])array).clone();
            }
        }
        ,
        LONG{

            @Override
            int hashCode(Object array) {
                return Arrays.hashCode((long[])array);
            }

            @Override
            boolean equals(Object array1, Object array2) {
                return array2 instanceof long[] && Arrays.equals((long[])array1, (long[])array2);
            }

            @Override
            Object clone(Object array) {
                return ((long[])array).clone();
            }
        }
        ,
        BOOLEAN{

            @Override
            int hashCode(Object array) {
                return Arrays.hashCode((boolean[])array);
            }

            @Override
            boolean equals(Object array1, Object array2) {
                return array2 instanceof boolean[] && Arrays.equals((boolean[])array1, (boolean[])array2);
            }

            @Override
            Object clone(Object array) {
                return ((boolean[])array).clone();
            }
        }
        ,
        BYTE{

            @Override
            int hashCode(Object array) {
                return Arrays.hashCode((byte[])array);
            }

            @Override
            boolean equals(Object array1, Object array2) {
                return array2 instanceof byte[] && Arrays.equals((byte[])array1, (byte[])array2);
            }

            @Override
            Object clone(Object array) {
                return ((byte[])array).clone();
            }
        }
        ,
        DOUBLE{

            @Override
            int hashCode(Object array) {
                return Arrays.hashCode((double[])array);
            }

            @Override
            boolean equals(Object array1, Object array2) {
                return array2 instanceof double[] && Arrays.equals((double[])array1, (double[])array2);
            }

            @Override
            Object clone(Object array) {
                return ((double[])array).clone();
            }
        }
        ,
        STRING{

            @Override
            int hashCode(Object array) {
                return Arrays.hashCode((String[])array);
            }

            @Override
            boolean equals(Object array1, Object array2) {
                return array2 instanceof String[] && Arrays.equals((String[])array1, (String[])array2);
            }

            @Override
            Object clone(Object array) {
                return ((String[])array).clone();
            }
        }
        ,
        SHORT{

            @Override
            int hashCode(Object array) {
                return Arrays.hashCode((short[])array);
            }

            @Override
            boolean equals(Object array1, Object array2) {
                return array2 instanceof short[] && Arrays.equals((short[])array1, (short[])array2);
            }

            @Override
            Object clone(Object array) {
                return ((short[])array).clone();
            }
        }
        ,
        CHAR{

            @Override
            int hashCode(Object array) {
                return Arrays.hashCode((char[])array);
            }

            @Override
            boolean equals(Object array1, Object array2) {
                return array2 instanceof char[] && Arrays.equals((char[])array1, (char[])array2);
            }

            @Override
            Object clone(Object array) {
                return ((char[])array).clone();
            }
        }
        ,
        FLOAT{

            @Override
            int hashCode(Object array) {
                return Arrays.hashCode((float[])array);
            }

            @Override
            boolean equals(Object array1, Object array2) {
                return array2 instanceof float[] && Arrays.equals((float[])array1, (float[])array2);
            }

            @Override
            Object clone(Object array) {
                return ((float[])array).clone();
            }
        };


        abstract int hashCode(Object var1);

        abstract boolean equals(Object var1, Object var2);

        abstract Object clone(Object var1);

        public static Type from(Object array) {
            if (!array.getClass().isArray()) {
                throw new IllegalArgumentException(array + " is not an array, it's a " + array.getClass());
            }
            if (array instanceof int[]) {
                return INT;
            }
            if (array instanceof long[]) {
                return LONG;
            }
            if (array instanceof boolean[]) {
                return BOOLEAN;
            }
            if (array instanceof byte[]) {
                return BYTE;
            }
            if (array instanceof double[]) {
                return DOUBLE;
            }
            if (array instanceof String[]) {
                return STRING;
            }
            if (array instanceof short[]) {
                return SHORT;
            }
            if (array instanceof char[]) {
                return CHAR;
            }
            if (array instanceof float[]) {
                return FLOAT;
            }
            throw new IllegalArgumentException("Unrecognized array type " + array.getClass().getComponentType());
        }
    }
}

