/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.FullSizeProperty;

class IntArrayProperty
extends FullSizeProperty {
    private final int[] value;

    IntArrayProperty(long propertyKeyId, int[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public int[] value() {
        return (int[])this.value.clone();
    }

    @Override
    public boolean valueEquals(Object value) {
        if (value instanceof int[]) {
            return Arrays.equals(this.value, (int[])value);
        }
        return this.valueCompare(this.value, value);
    }

    @Override
    int valueHash() {
        return Arrays.hashCode(this.value);
    }

    @Override
    boolean hasEqualValue(FullSizeProperty that) {
        return Arrays.equals(this.value, ((IntArrayProperty)that).value);
    }
}

