/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.SafeProperty;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyDatas;

final class CharProperty
extends SafeProperty {
    private final char value;
    private final long propertyKeyId;

    CharProperty(long propertyKeyId, char value) {
        this.propertyKeyId = propertyKeyId;
        this.value = value;
    }

    @Override
    public long propertyKeyId() {
        return this.propertyKeyId;
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof Character) {
            return this.value == ((Character)other).charValue();
        }
        return this.valueCompare(Character.valueOf(this.value), other);
    }

    @Override
    public Character value() {
        return Character.valueOf(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CharProperty) {
            CharProperty that = (CharProperty)o;
            return this.propertyKeyId == that.propertyKeyId && this.value == that.value;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = this.value;
        result = 31 * result + (int)(this.propertyKeyId ^ this.propertyKeyId >>> 32);
        return result;
    }

    @Override
    @Deprecated
    public PropertyData asPropertyDataJustForIntegration() {
        return PropertyDatas.forChar((int)this.propertyKeyId, -1L, this.value);
    }
}

