/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.FullSizeProperty;

class CharArrayProperty
extends FullSizeProperty {
    private final char[] value;

    CharArrayProperty(long propertyKeyId, char[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public char[] value() {
        return (char[])this.value.clone();
    }

    @Override
    public boolean valueEquals(Object value) {
        if (value instanceof char[]) {
            return Arrays.equals(this.value, (char[])value);
        }
        return this.valueCompare(this.value, value);
    }

    @Override
    int valueHash() {
        return Arrays.hashCode(this.value);
    }

    @Override
    boolean hasEqualValue(FullSizeProperty that) {
        return Arrays.equals(this.value, ((CharArrayProperty)that).value);
    }
}

