/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import org.neo4j.kernel.api.DataWrite;
import org.neo4j.kernel.api.KernelTransactionImplementation;
import org.neo4j.kernel.api.ReadStatement;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.SafeProperty;
import org.neo4j.kernel.impl.api.constraints.ConstraintValidationKernelException;

public class DataStatement
extends ReadStatement
implements DataWrite {
    DataStatement(KernelTransactionImplementation transaction, Statement statement) {
        super(transaction, statement);
    }

    @Override
    public long nodeCreate() {
        this.assertOpen();
        return this.legacyOps().nodeCreate(this.state);
    }

    @Override
    public void nodeDelete(long nodeId) {
        this.assertOpen();
        this.dataWrite().nodeDelete(this.state, nodeId);
    }

    @Override
    public long relationshipCreate(long relationshipTypeId, long startNodeId, long endNodeId) throws RelationshipTypeIdNotFoundKernelException, EntityNotFoundException {
        this.assertOpen();
        return this.legacyOps().relationshipCreate(this.state, relationshipTypeId, startNodeId, endNodeId);
    }

    @Override
    public void relationshipDelete(long relationshipId) {
        this.assertOpen();
        this.dataWrite().relationshipDelete(this.state, relationshipId);
    }

    @Override
    public boolean nodeAddLabel(long nodeId, long labelId) throws EntityNotFoundException, ConstraintValidationKernelException {
        this.assertOpen();
        return this.dataWrite().nodeAddLabel(this.state, nodeId, labelId);
    }

    @Override
    public boolean nodeRemoveLabel(long nodeId, long labelId) throws EntityNotFoundException {
        this.assertOpen();
        return this.dataWrite().nodeRemoveLabel(this.state, nodeId, labelId);
    }

    @Override
    public Property nodeSetProperty(long nodeId, SafeProperty property) throws EntityNotFoundException, ConstraintValidationKernelException {
        this.assertOpen();
        return this.dataWrite().nodeSetProperty(this.state, nodeId, property);
    }

    @Override
    public Property relationshipSetProperty(long relationshipId, SafeProperty property) throws EntityNotFoundException {
        this.assertOpen();
        return this.dataWrite().relationshipSetProperty(this.state, relationshipId, property);
    }

    @Override
    public Property graphSetProperty(SafeProperty property) {
        this.assertOpen();
        return this.dataWrite().graphSetProperty(this.state, property);
    }

    @Override
    public Property nodeRemoveProperty(long nodeId, long propertyKeyId) throws EntityNotFoundException {
        this.assertOpen();
        return this.dataWrite().nodeRemoveProperty(this.state, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipRemoveProperty(long relationshipId, long propertyKeyId) throws EntityNotFoundException {
        this.assertOpen();
        return this.dataWrite().relationshipRemoveProperty(this.state, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphRemoveProperty(long propertyKeyId) {
        this.assertOpen();
        return this.dataWrite().graphRemoveProperty(this.state, propertyKeyId);
    }
}

