/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.kernel.api.DataStatement;
import org.neo4j.kernel.api.InvalidTransactionTypeException;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadStatement;
import org.neo4j.kernel.api.SchemaStatement;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class ThreadToStatementContextBridge
extends LifecycleAdapter {
    protected final KernelAPI kernelAPI;
    private final AbstractTransactionManager txManager;
    private boolean isShutdown = false;

    public ThreadToStatementContextBridge(KernelAPI kernelAPI, AbstractTransactionManager txManager) {
        this.kernelAPI = kernelAPI;
        this.txManager = txManager;
    }

    public ReadStatement readStatement() {
        return this.transaction().acquireReadStatement();
    }

    public DataStatement dataStatement() {
        try {
            return this.transaction().acquireDataStatement();
        }
        catch (InvalidTransactionTypeException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    public SchemaStatement schemaStatement() {
        try {
            return this.transaction().acquireSchemaStatement();
        }
        catch (InvalidTransactionTypeException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    private KernelTransaction transaction() {
        this.checkIfShutdown();
        KernelTransaction transaction = this.txManager.getKernelTransaction();
        if (transaction == null) {
            throw new NotInTransactionException();
        }
        return transaction;
    }

    @Override
    public void shutdown() throws Throwable {
        this.isShutdown = true;
    }

    private void checkIfShutdown() {
        if (this.isShutdown) {
            throw new DatabaseShutdownException();
        }
    }

    public void assertInTransaction() {
        this.txManager.assertInTransaction();
    }
}

