/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Format {
    private static final String[] BYTE_SIZES = new String[]{"B", "kB", "MB", "GB"};
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSSZ";
    public static final String TIME_FORMAT = "HH:mm:ss.SSS";
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final ThreadLocalFormat DATE = new ThreadLocalFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
    private static final ThreadLocalFormat TIME = new ThreadLocalFormat("HH:mm:ss.SSS");

    public static String date() {
        return Format.date(DEFAULT_TIME_ZONE);
    }

    public static String date(TimeZone timeZone) {
        return Format.date(new Date(), timeZone);
    }

    public static String date(long millis) {
        return Format.date(millis, DEFAULT_TIME_ZONE);
    }

    public static String date(long millis, TimeZone timeZone) {
        return Format.date(new Date(millis), timeZone);
    }

    public static String date(Date date) {
        return Format.date(date, DEFAULT_TIME_ZONE);
    }

    public static String date(Date date, TimeZone timeZone) {
        return DATE.format(date, timeZone);
    }

    public static String time() {
        return Format.time(DEFAULT_TIME_ZONE);
    }

    public static String time(TimeZone timeZone) {
        return Format.time(new Date());
    }

    public static String time(long millis) {
        return Format.time(millis, DEFAULT_TIME_ZONE);
    }

    public static String time(long millis, TimeZone timeZone) {
        return Format.time(new Date(millis), timeZone);
    }

    public static String time(Date date) {
        return Format.time(date, DEFAULT_TIME_ZONE);
    }

    public static String time(Date date, TimeZone timeZone) {
        return TIME.format(date, timeZone);
    }

    public static String bytes(long bytes) {
        double size = bytes;
        for (String suffix : BYTE_SIZES) {
            if (size < 1024.0) {
                return String.format("%.2f %s", size, suffix);
            }
            size /= 1024.0;
        }
        return String.format("%.2f TB", size);
    }

    private Format() {
    }

    private static class ThreadLocalFormat
    extends ThreadLocal<DateFormat> {
        private final String format;

        ThreadLocalFormat(String format) {
            this.format = format;
        }

        String format(Date date, TimeZone timeZone) {
            DateFormat dateFormat = (DateFormat)this.get();
            dateFormat.setTimeZone(timeZone);
            return dateFormat.format(date);
        }

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(this.format);
        }
    }
}

