/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.io.File;
import java.util.ArrayList;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.Settings;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.GraphDatabaseConfigurationMigrator;
import org.neo4j.kernel.configuration.Migrator;
import org.neo4j.kernel.configuration.Title;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.cache.MonitorGc;

@Description(value="Settings for the Community edition of Neo4j")
public abstract class GraphDatabaseSettings {
    @Migrator
    private static final ConfigurationMigrator migrator = new GraphDatabaseConfigurationMigrator();
    @Title(value="Read only database")
    @Description(value="Only allow read operations from this Neo4j instance. This mode still requires write access to the directory for lock purposes")
    public static final Setting<Boolean> read_only = Settings.setting("read_only", Settings.BOOLEAN, "false");
    @Description(value="The type of cache to use for nodes and relationships. Note that the Neo4j Enterprise Edition has the additional 'gcr' cache type. See the chapter on caches in the manual for more information.")
    public static final Setting<String> cache_type = Settings.setting("cache_type", Settings.options(GraphDatabaseSettings.availableCaches()), GraphDatabaseSettings.availableCaches()[0]);
    @Description(value="Print out the effective Neo4j configuration after startup.")
    public static final Setting<Boolean> dump_configuration = Settings.setting("dump_configuration", Settings.BOOLEAN, "false");
    @Description(value="The name of the Transaction Manager service to use as defined in the TM service provider constructor.")
    public static final Setting<String> tx_manager_impl = Settings.setting("tx_manager_impl", Settings.STRING, "native", Settings.illegalValueMessage("Must be class name of TransactionManager implementation", Settings.matches(".+")));
    @Description(value="Whether to allow a store upgrade in case the current version of the database starts against an older store version. Setting this to true does not guarantee successful upgrade, just that it allows an attempt at it.")
    public static final Setting<Boolean> allow_store_upgrade = Settings.setting("allow_store_upgrade", Settings.BOOLEAN, "false");
    @Description(value="Determines whether any TransactionInterceptors loaded will intercept externally received transactions (e.g. in HA) before they reach the logical log and are applied to the store.")
    public static final Setting<Boolean> intercept_deserialized_transactions = Settings.setting("intercept_deserialized_transactions", Settings.BOOLEAN, "false");
    @Description(value="Enable this to specify a parser other than the default one.")
    public static final Setting<String> cypher_parser_version = Settings.setting("cypher_parser_version", Settings.options("1.9", "2.0", "legacy"), Settings.NO_DEFAULT);
    @Description(value="Used to set the number of Cypher query execution plans that are cached.")
    public static Setting<Integer> query_cache_size = Settings.setting("query_cache_size", Settings.INTEGER, "100", Settings.min(0));
    @Description(value="The directory where the database files are located.")
    public static final Setting<File> store_dir = Settings.setting("store_dir", Settings.PATH, Settings.NO_DEFAULT);
    @Description(value="The base name for the Neo4j Store files, either an absolute path or relative to the store_dir setting. This should generally not be changed.")
    public static final Setting<File> neo_store = Settings.setting("neo_store", Settings.PATH, "neostore", Settings.basePath(store_dir));
    @Description(value="The base name for the logical log files, either an absolute path or relative to the store_dir setting. This should generally not be changed.")
    public static final Setting<File> logical_log = Settings.setting("logical_log", Settings.PATH, "nioneo_logical.log", Settings.basePath(store_dir));
    @Description(value="Whether to enable logging to a remote server or not.")
    public static final Setting<Boolean> remote_logging_enabled = Settings.setting("remote_logging_enabled", Settings.BOOLEAN, "false");
    @Description(value="Host for remote logging using LogBack SocketAppender.")
    public static final Setting<String> remote_logging_host = Settings.setting("remote_logging_host", Settings.STRING, "127.0.0.1", Settings.illegalValueMessage("Must be a valid hostname", Settings.matches(".+")));
    @Description(value="Port for remote logging using LogBack SocketAppender.")
    public static final Setting<Integer> remote_logging_port = Settings.setting("remote_logging_port", Settings.INTEGER, "4560", Settings.port);
    @Description(value="Threshold in bytes for when database logs (text logs, for debugging, that is) are rotated.")
    public static final Setting<Integer> threshold_for_logging_rotation = Settings.setting("logging.threshold_for_rotation", Settings.INTEGER, "104857600", Settings.min(1));
    @Description(value="Controls the auto indexing feature for nodes. Setting to false shuts it down, while true enables it by default for properties listed in the node_keys_indexable setting.")
    public static final Setting<Boolean> node_auto_indexing = Settings.setting("node_auto_indexing", Settings.BOOLEAN, "false");
    @Description(value="A list of property names (comma separated) that will be indexed by default. This applies to Nodes only.")
    public static final Setting<String> node_keys_indexable = Settings.setting("node_keys_indexable", Settings.STRING, Settings.NO_DEFAULT, Settings.illegalValueMessage("Must be a comma-separated list of keys to be indexed", Settings.matches(".+")));
    @Description(value="Controls the auto indexing feature for relationships. Setting to false shuts it down, while true enables it by default for properties listed in the relationship_keys_indexable setting.")
    public static final Setting<Boolean> relationship_auto_indexing = Settings.setting("relationship_auto_indexing", Settings.BOOLEAN, "false");
    @Description(value=" A list of property names (comma separated) that will be indexed by default. This applies to Relationships only.")
    public static final Setting<String> relationship_keys_indexable = Settings.setting("relationship_keys_indexable", Settings.STRING, Settings.NO_DEFAULT, Settings.illegalValueMessage("Must be a comma-separated list of keys to be indexed", Settings.matches(".+")));
    @Description(value="Integer value that sets the maximum number of open lucene index searchers.")
    public static Setting<Integer> lucene_searcher_cache_size = Settings.setting("lucene_searcher_cache_size", Settings.INTEGER, Integer.toString(Integer.MAX_VALUE), Settings.min(1));
    @Description(value="NOTE: This no longer has any effect. Integer value that sets the maximum number of open lucene index writers.")
    @Deprecated
    public static Setting<Integer> lucene_writer_cache_size = Settings.setting("lucene_writer_cache_size", Settings.INTEGER, Integer.toString(Integer.MAX_VALUE), Settings.min(1));
    @Description(value="Determines whether any TransactionInterceptors loaded will intercept prepared transactions before they reach the logical log.")
    public static final Setting<Boolean> intercept_committing_transactions = Settings.setting("intercept_committing_transactions", Settings.BOOLEAN, "false");
    @Description(value="Make Neo4j keep the logical transaction logs for being able to backup the database.Can be used for specifying the threshold to prune logical logs after. For example \"10 days\" will prune logical logs that only contains transactions older than 10 days from the current time, or \"100k txs\" will keep the 100k latest transactions and prune any older transactions.")
    public static final Setting<String> keep_logical_logs = Settings.setting("keep_logical_logs", Settings.STRING, "true", Settings.illegalValueMessage("Must be 'true'/'false' or of format '<number><optional unit> <type>' for example '100M size' for limiting logical log space on disk to 100Mb, or '200k txs' for limiting the number of transactions to keep to 200 000.", Settings.matches(".+")));
    @Description(value="Specifies at which file size the logical log will auto-rotate. 0 means that no rotation will automatically occur based on file size. Default is 25M")
    public static final Setting<Long> logical_log_rotation_threshold = Settings.setting("logical_log_rotation_threshold", Settings.LONG_WITH_OPTIONAL_UNIT, "25M");
    @Description(value="Use a quick approach for rebuilding the ID generators. This give quicker recovery time, but will limit the ability to reuse the space of deleted entities.")
    public static final Setting<Boolean> rebuild_idgenerators_fast = Settings.setting("rebuild_idgenerators_fast", Settings.BOOLEAN, "true");
    @Description(value="Tell Neo4j to use memory mapped buffers for accessing the native storage layer.")
    public static final Setting<Boolean> use_memory_mapped_buffers = Settings.setting("use_memory_mapped_buffers", Settings.BOOLEAN, Boolean.toString(!Settings.osIsWindows()));
    @Description(value="Target size for pages of mapped memory.")
    public static final Setting<Long> mapped_memory_page_size = Settings.setting("mapped_memory_page_size", Settings.BYTES, "1M");
    @Description(value="The size to allocate for a memory mapping pool to be shared between all stores.")
    public static final Setting<Long> all_stores_total_mapped_memory_size = Settings.setting("all_stores_total_mapped_memory_size", Settings.BYTES, "500M");
    @Description(value="Tell Neo4j to regularly log memory mapping statistics.")
    public static final Setting<Boolean> log_mapped_memory_stats = Settings.setting("log_mapped_memory_stats", Settings.BOOLEAN, "false");
    @Description(value="The file where Neo4j will record memory mapping statistics.")
    public static final Setting<File> log_mapped_memory_stats_filename = Settings.setting("log_mapped_memory_stats_filename", Settings.PATH, "mapped_memory_stats.log", Settings.basePath(store_dir));
    @Description(value="The number of records to be loaded between regular logging of memory mapping statistics.")
    public static final Setting<Integer> log_mapped_memory_stats_interval = Settings.setting("log_mapped_memory_stats_interval", Settings.INTEGER, "1000000");
    @Description(value="The size to allocate for memory mapping the node store.")
    public static final Setting<Long> nodestore_mapped_memory_size = Settings.setting("neostore.nodestore.db.mapped_memory", Settings.BYTES, "20M");
    @Description(value="The size to allocate for memory mapping the property value store.")
    public static final Setting<Long> nodestore_propertystore_mapped_memory_size = Settings.setting("neostore.propertystore.db.mapped_memory", Settings.BYTES, "90M");
    @Description(value="The size to allocate for memory mapping the store for property key indexes.")
    public static final Setting<Long> nodestore_propertystore_index_mapped_memory_size = Settings.setting("neostore.propertystore.db.index.mapped_memory", Settings.BYTES, "1M");
    @Description(value="The size to allocate for memory mapping the store for property key strings.")
    public static final Setting<Long> nodestore_propertystore_index_keys_mapped_memory_size = Settings.setting("neostore.propertystore.db.index.keys.mapped_memory", Settings.BYTES, "1M");
    @Description(value="The size to allocate for memory mapping the string property store.")
    public static final Setting<Long> strings_mapped_memory_size = Settings.setting("neostore.propertystore.db.strings.mapped_memory", Settings.BYTES, "130M");
    @Description(value="The size to allocate for memory mapping the array property store.")
    public static final Setting<Long> arrays_mapped_memory_size = Settings.setting("neostore.propertystore.db.arrays.mapped_memory", Settings.BYTES, "130M");
    @Description(value="The size to allocate for memory mapping the relationship store.")
    public static final Setting<Long> relationshipstore_mapped_memory_size = Settings.setting("neostore.relationshipstore.db.mapped_memory", Settings.BYTES, "100M");
    @Description(value="How many relationships to read at a time during iteration")
    public static final Setting<Integer> relationship_grab_size = Settings.setting("relationship_grab_size", Settings.INTEGER, "100", Settings.min(1));
    @Description(value="Whether to grab locks on files or not.")
    @Deprecated
    public static final Setting<Boolean> grab_file_lock = Settings.setting("grab_file_lock", Settings.BOOLEAN, "true");
    @Description(value="Specifies the block size for storing strings. This parameter is only honored when the store is created, otherwise it is ignored. Note that each character in a string occupies two bytes, meaning that a block size of 120 (the default size) will hold a 60 character long string before overflowing into a second block. Also note that each block carries an overhead of 8 bytes. This means that if the block size is 120, the size of the stored records will be 128 bytes.")
    public static final Setting<Integer> string_block_size = Settings.setting("string_block_size", Settings.INTEGER, "120", Settings.min(1));
    @Description(value="Specifies the block size for storing arrays. This parameter is only honored when the store is created, otherwise it is ignored. The default block size is 120 bytes, and the overhead of each block is the same as for string blocks, i.e., 8 bytes.")
    public static final Setting<Integer> array_block_size = Settings.setting("array_block_size", Settings.INTEGER, "120", Settings.min(1));
    @Description(value="Specifies the block size for storing labels exceeding in-lined space in node record. This parameter is only honored when the store is created, otherwise it is ignored. The default block size is 60 bytes, and the overhead of each block is the same as for string blocks, i.e., 8 bytes.")
    public static final Setting<Integer> label_block_size = Settings.setting("label_block_size", Settings.INTEGER, "60", Settings.min(1));
    @Description(value="Mark this database as a backup slave.")
    public static final Setting<Boolean> backup_slave = Settings.setting("backup_slave", Settings.BOOLEAN, "false");
    @Description(value="An identifier that uniquely identifies this graph database instance within this JVM. Defaults to an auto-generated number depending on how many instance are started in this JVM.")
    public static final Setting<String> forced_kernel_id = Settings.setting("forced_kernel_id", Settings.STRING, Settings.NO_DEFAULT, Settings.illegalValueMessage("invalid kernel identifier", Settings.matches("[a-zA-Z0-9]*")));
    public static final Setting<Boolean> execution_guard_enabled = Settings.setting("execution_guard_enabled", Settings.BOOLEAN, "false");
    @Description(value="Amount of time in ms the GC monitor thread will wait before taking another measurement.")
    public static final Setting<Long> gc_monitor_interval = MonitorGc.Configuration.gc_monitor_wait_time;
    @Description(value="The amount of time in ms the monitor thread has to be blocked before logging a message it was blocked.")
    public static final Setting<Long> gc_monitor_block_threshold = MonitorGc.Configuration.gc_monitor_threshold;
    @Description(value="The amount of memory to use for the node cache (when using the 'gcr' cache).")
    @Deprecated
    public static final Setting<String> node_cache_size = Settings.setting("node_cache_size", Settings.STRING, Settings.NO_DEFAULT, Settings.matches("\\d+[kmgKMG]?"));
    @Description(value="The amount of memory to use for the relationship cache (when using the 'gcr' cache).")
    @Deprecated
    public static final Setting<String> relationship_cache_size = Settings.setting("relationship_cache_size", Settings.STRING, Settings.NO_DEFAULT, Settings.matches("\\d+[kmgKMG]?"));
    @Description(value="The fraction of the heap (1%-10%) to use for the base array in the node cache (when using the 'gcr' cache).")
    @Deprecated
    public static final Setting<Float> node_cache_array_fraction = Settings.setting("node_cache_array_fraction", Settings.FLOAT, "1.0", Settings.range(Float.valueOf(1.0f), Float.valueOf(10.0f)));
    @Description(value="The fraction of the heap (1%-10%) to use for the base array in the relationship cache (when using the 'gcr' cache).")
    @Deprecated
    public static final Setting<Float> relationship_cache_array_fraction = Settings.setting("relationship_cache_array_fraction", Settings.FLOAT, "1.0", Settings.range(Float.valueOf(1.0f), Float.valueOf(10.0f)));
    @Description(value="The minimal time that must pass in between logging statistics from the cache (when using the 'gcr' cache).")
    @Deprecated
    public static final Setting<String> gcr_cache_min_log_interval = Settings.setting("gcr_cache_min_log_interval", Settings.STRING, "60s", Settings.matches("\\d+(ms|s|m)"));

    private static String[] availableCaches() {
        ArrayList<String> available = new ArrayList<String>();
        for (CacheProvider cacheProvider : Service.load(CacheProvider.class)) {
            available.add(cacheProvider.getName());
        }
        for (String prioritized : new String[]{"soft", "gcr"}) {
            if (!available.remove(prioritized)) continue;
            available.add(0, prioritized);
        }
        return available.toArray(new String[available.size()]);
    }
}

