/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Iterator;

public interface DependencyResolver {
    public <T> T resolveDependency(Class<T> var1) throws IllegalArgumentException;

    public <T> T resolveDependency(Class<T> var1, SelectionStrategy<T> var2) throws IllegalArgumentException;

    public static abstract class Adapter
    implements DependencyResolver {
        private static final SelectionStrategy FIRST = new SelectionStrategy(){

            public Object select(Class type, Iterable candidates) throws IllegalArgumentException {
                Iterator iterator = candidates.iterator();
                if (!iterator.hasNext()) {
                    throw new IllegalArgumentException("Could not resolve dependency of type:" + type.getName());
                }
                return iterator.next();
            }
        };

        private static <T> SelectionStrategy<T> first() {
            return FIRST;
        }

        @Override
        public <T> T resolveDependency(Class<T> type) throws IllegalArgumentException {
            return this.resolveDependency(type, Adapter.first());
        }
    }

    public static interface SelectionStrategy<T> {
        public T select(Class<T> var1, Iterable<T> var2) throws IllegalArgumentException;
    }
}

