/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.BidirectionalUniquenessFilter;
import org.neo4j.graphdb.traversal.BranchCollisionDetector;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.SideSelector;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;
import org.neo4j.graphdb.traversal.UniquenessFilter;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.kernel.impl.traversal.AbstractTraverserIterator;
import org.neo4j.kernel.impl.traversal.AsOneStartBranch;
import org.neo4j.kernel.impl.traversal.BidirectionalTraversalDescriptionImpl;
import org.neo4j.kernel.impl.traversal.TraversalDescriptionImpl;

class BidirectionalTraverserIterator
extends AbstractTraverserIterator {
    private final BranchCollisionDetector collisionDetector;
    private Iterator<Path> foundPaths;
    private SideSelector selector;
    private Map<Direction, Side> sides = new EnumMap<Direction, Side>(Direction.class);
    private final BidirectionalUniquenessFilter uniqueness;
    private final Predicate<Path> uniquenessPredicate = new Predicate<Path>(){

        @Override
        public boolean accept(Path path) {
            return BidirectionalTraverserIterator.this.uniqueness.checkFull(path);
        }
    };

    BidirectionalTraverserIterator(BidirectionalTraversalDescriptionImpl description, Iterable<Node> startNodes, Iterable<Node> endNodes) {
        TraversalDescriptionImpl start = (TraversalDescriptionImpl)description.start;
        TraversalDescriptionImpl end = (TraversalDescriptionImpl)description.end;
        this.sides.put(Direction.OUTGOING, new Side(start));
        this.sides.put(Direction.INCOMING, new Side(end));
        this.uniqueness = this.makeSureStartAndEndHasSameUniqueness(start, end);
        this.selector = this.alwaysOutgoingSide();
        BranchSelector startSelector = start.branchOrdering.create(new AsOneStartBranch(this, startNodes, start.initialState), start.expander);
        BranchSelector endSelector = end.branchOrdering.create(new AsOneStartBranch(this, endNodes, end.initialState), end.expander);
        this.selector = description.sideSelector.create(startSelector, endSelector, description.maxDepth);
        this.collisionDetector = description.collisionPolicy.create(description.collisionEvaluator);
    }

    private BidirectionalUniquenessFilter makeSureStartAndEndHasSameUniqueness(TraversalDescriptionImpl start, TraversalDescriptionImpl end) {
        boolean parameterDiffers;
        if (!start.uniqueness.equals(end.uniqueness)) {
            throw new IllegalArgumentException("Start and end uniqueness factories differ, they need to be the same currently. Start side has " + start.uniqueness + ", end side has " + end.uniqueness);
        }
        boolean bl = start.uniquenessParameter == null || end.uniquenessParameter == null ? start.uniquenessParameter != end.uniquenessParameter : (parameterDiffers = !start.uniquenessParameter.equals(end.uniquenessParameter));
        if (parameterDiffers) {
            throw new IllegalArgumentException("Start and end uniqueness parameters differ, they need to be the same currently. Start side has " + start.uniquenessParameter + ", " + "end side has " + end.uniquenessParameter);
        }
        UniquenessFilter uniqueness = start.uniqueness.create(start.uniquenessParameter);
        if (!(uniqueness instanceof BidirectionalUniquenessFilter)) {
            throw new IllegalArgumentException("You must supply a BidirectionalUniquenessFilter, not just a UniquenessFilter.");
        }
        return (BidirectionalUniquenessFilter)uniqueness;
    }

    private SideSelector alwaysOutgoingSide() {
        return new SideSelector(){

            @Override
            public TraversalBranch next(TraversalContext metadata) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Direction currentSide() {
                return Direction.OUTGOING;
            }
        };
    }

    @Override
    protected Path fetchNextOrNull() {
        if (this.foundPaths != null) {
            if (this.foundPaths.hasNext()) {
                ++this.numberOfPathsReturned;
                Path next = this.foundPaths.next();
                return next;
            }
            this.foundPaths = null;
        }
        TraversalBranch result = null;
        while (true) {
            if ((result = this.selector.next(this)) == null) {
                return null;
            }
            Iterable<Path> pathCollisions = this.collisionDetector.evaluate(result, this.selector.currentSide());
            if (pathCollisions == null) continue;
            this.foundPaths = this.uniquenessFiltered(pathCollisions.iterator());
            if (this.foundPaths.hasNext()) break;
        }
        ++this.numberOfPathsReturned;
        Path next = this.foundPaths.next();
        return next;
    }

    private Iterator<Path> uniquenessFiltered(Iterator<Path> paths) {
        return new FilteringIterator<Path>(paths, this.uniquenessPredicate);
    }

    private Side currentSideDescription() {
        return this.sides.get((Object)this.selector.currentSide());
    }

    @Override
    public Evaluation evaluate(TraversalBranch branch, BranchState state) {
        return ((Side)this.currentSideDescription()).description.evaluator.evaluate(branch, state);
    }

    @Override
    public boolean isUniqueFirst(TraversalBranch branch) {
        return this.uniqueness.checkFirst(branch);
    }

    @Override
    public boolean isUnique(TraversalBranch branch) {
        return this.uniqueness.check(branch);
    }

    private static class Side {
        private final TraversalDescriptionImpl description;

        public Side(TraversalDescriptionImpl description) {
            this.description = description;
        }
    }
}

