/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.RecordLoad;
import org.neo4j.kernel.impl.nioneo.store.RecordSerializer;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaRuleAccess;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class SchemaStore
extends AbstractDynamicStore
implements Iterable<SchemaRule>,
SchemaRuleAccess {
    public static final String TYPE_DESCRIPTOR = "SchemaStore";
    public static final String VERSION = SchemaStore.buildTypeDescriptorAndVersion("SchemaStore");
    public static final int BLOCK_SIZE = 56;

    public SchemaStore(File fileName, Config conf, IdType idType, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger) {
        super(fileName, conf, idType, idGeneratorFactory, windowPoolFactory, fileSystemAbstraction, stringLogger);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, DynamicRecord record) throws FAILURE {
        processor.processSchema(this, record);
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    public Collection<DynamicRecord> allocateFrom(SchemaRule rule) {
        RecordSerializer serializer = new RecordSerializer();
        serializer = serializer.append(rule);
        return SchemaStore.allocateRecordsFromBytes(serializer.serialize(), Arrays.asList(this.forceGetRecord(rule.getId())).iterator(), this.recordAllocator);
    }

    public Iterator<SchemaRule> loadAllSchemaRules() {
        return new PrefetchingIterator<SchemaRule>(){
            private final long highestId;
            private long currentId;
            private final byte[] scratchData;
            {
                this.highestId = SchemaStore.this.getHighestPossibleIdInUse();
                this.currentId = 1L;
                this.scratchData = SchemaStore.this.newRecordBuffer();
            }

            @Override
            protected SchemaRule fetchNextOrNull() {
                while (this.currentId <= this.highestId) {
                    long id;
                    ++this.currentId;
                    DynamicRecord record = SchemaStore.this.forceGetRecord(id);
                    if (!record.inUse() || !record.isStartRecord()) continue;
                    try {
                        return SchemaStore.this.getSchemaRule(id, this.scratchData);
                    }
                    catch (MalformedSchemaRuleException e) {
                        throw Exceptions.launderedException(e);
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Iterator<SchemaRule> iterator() {
        return this.loadAllSchemaRules();
    }

    private byte[] newRecordBuffer() {
        return new byte[this.getRecordSize() * 4];
    }

    @Override
    public SchemaRule loadSingleSchemaRule(long ruleId) throws MalformedSchemaRuleException {
        return this.forceGetSchemaRule(ruleId, this.newRecordBuffer());
    }

    private SchemaRule getSchemaRule(long id, byte[] buffer) throws MalformedSchemaRuleException {
        return SchemaStore.readSchemaRule(id, this.getRecords(id), buffer);
    }

    private SchemaRule forceGetSchemaRule(long id, byte[] buffer) throws MalformedSchemaRuleException {
        Collection<DynamicRecord> records = this.getRecords(id, RecordLoad.FORCE);
        for (DynamicRecord record : records) {
            this.ensureHeavy(record);
        }
        return SchemaStore.readSchemaRule(id, records, buffer);
    }

    public static SchemaRule readSchemaRule(long id, Collection<DynamicRecord> records) throws MalformedSchemaRuleException {
        return SchemaStore.readSchemaRule(id, records, new byte[224]);
    }

    private static SchemaRule readSchemaRule(long id, Collection<DynamicRecord> records, byte[] buffer) throws MalformedSchemaRuleException {
        ByteBuffer scratchBuffer = SchemaStore.concatData(records, buffer);
        return SchemaRule.Kind.deserialize(id, scratchBuffer);
    }
}

