/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Iterator;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.operations.StatementState;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.CacheLoader;
import org.neo4j.kernel.impl.api.CacheUpdateListener;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.cache.SizeOfObject;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.WritableTransactionState;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.util.ArrayMap;

public abstract class Primitive
implements SizeOfObject {
    protected static final Property[] NO_PROPERTIES = new Property[0];

    Primitive(boolean newPrimitive) {
        if (newPrimitive) {
            this.setEmptyProperties();
        }
    }

    public abstract long getId();

    public Iterator<Property> getProperties(StatementState state, CacheLoader<Iterator<Property>> loader, CacheUpdateListener updateListener) {
        return this.ensurePropertiesLoaded(state, loader, updateListener);
    }

    public Property getProperty(StatementState state, CacheLoader<Iterator<Property>> loader, CacheUpdateListener updateListener, int key) {
        this.ensurePropertiesLoaded(state, loader, updateListener);
        return this.getCachedProperty(key);
    }

    public PrimitiveLongIterator getPropertyKeys(StatementState state, CacheLoader<Iterator<Property>> cacheLoader, CacheUpdateListener updateListener) {
        this.ensurePropertiesLoaded(state, cacheLoader, updateListener);
        return this.getCachedPropertyKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<Property> ensurePropertiesLoaded(StatementState state, CacheLoader<Iterator<Property>> loader, CacheUpdateListener updateListener) {
        if (!this.hasLoadedProperties()) {
            Primitive primitive = this;
            synchronized (primitive) {
                if (!this.hasLoadedProperties()) {
                    try {
                        Iterator<Property> loadedProperties = loader.load(state, this.getId());
                        this.setProperties(loadedProperties);
                        updateListener.newSize(this, this.sizeOfObjectInBytesIncludingOverhead());
                    }
                    catch (InvalidRecordException e) {
                        throw new NotFoundException(this + " not found. This can be because someone " + "else deleted this entity while we were trying to read properties from it, or because of " + "concurrent modification of other properties on this entity. The problem should be temporary.", e);
                    }
                    catch (EntityNotFoundException e) {
                        throw new NotFoundException(this + " not found. This can be because someone " + "else deleted this entity while we were trying to read properties from it, or because of " + "concurrent modification of other properties on this entity. The problem should be temporary.", e);
                    }
                }
            }
        }
        return this.getCachedProperties();
    }

    protected abstract Iterator<Property> getCachedProperties();

    protected abstract Property getCachedProperty(int var1);

    protected abstract PrimitiveLongIterator getCachedPropertyKeys();

    protected abstract boolean hasLoadedProperties();

    protected abstract void setEmptyProperties();

    protected abstract void setProperties(Iterator<Property> var1);

    protected abstract PropertyData getPropertyForIndex(int var1);

    protected abstract void commitPropertyMaps(ArrayMap<Integer, PropertyData> var1, ArrayMap<Integer, PropertyData> var2, long var3);

    public int hashCode() {
        long id = this.getId();
        return (int)(id >>> 32 ^ id);
    }

    public abstract boolean equals(Object var1);

    private Object getPropertyValue(NodeManager nodeManager, PropertyData property) {
        Object value = property.getValue();
        if (value == null) {
            value = this.loadPropertyValue(nodeManager, property.getIndex());
            property.setNewValue(value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensurePropertiesLoaded(NodeManager nodeManager) {
        if (!this.hasLoadedProperties()) {
            Primitive primitive = this;
            synchronized (primitive) {
                if (!this.hasLoadedProperties()) {
                    try {
                        ArrayMap<Integer, PropertyData> loadedProperties = this.loadProperties(nodeManager);
                        this.setProperties(this.toPropertyIterator(loadedProperties));
                    }
                    catch (InvalidRecordException e) {
                        throw new NotFoundException(this.asProxy(nodeManager) + " not found. This can be because someone " + "else deleted this entity while we were trying to read properties from it, or because of " + "concurrent modification of other properties on this entity. The problem should be temporary.", e);
                    }
                }
            }
        }
    }

    private Iterator<Property> toPropertyIterator(ArrayMap<Integer, PropertyData> loadedProperties) {
        return Iterables.map(new Function<PropertyData, Property>(){

            @Override
            public Property apply(PropertyData from) {
                return Property.property(from.getIndex(), from.getValue());
            }
        }, loadedProperties.values()).iterator();
    }

    protected abstract ArrayMap<Integer, PropertyData> loadProperties(NodeManager var1);

    protected abstract Object loadPropertyValue(NodeManager var1, int var2);

    protected Object getCommittedPropertyValue(NodeManager nodeManager, String key) {
        PropertyData property;
        this.ensurePropertiesLoaded(nodeManager);
        Token index = nodeManager.getPropertyKeyTokenOrNull(key);
        if (index != null && (property = this.getPropertyForIndex(index.id())) != null) {
            return this.getPropertyValue(nodeManager, property);
        }
        return null;
    }

    public abstract WritableTransactionState.CowEntityElement getEntityElement(WritableTransactionState.PrimitiveElement var1, boolean var2);

    abstract PropertyContainer asProxy(NodeManager var1);
}

