/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.FunctionFromPrimitiveLong;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.StatementOperationParts;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.operations.StatementState;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.cleanup.CleanupService;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.traversal.OldTraverserWrapper;

public class NodeProxy
implements Node {
    private final NodeLookup nodeLookup;
    private final ThreadToStatementContextBridge statementCtxProvider;
    private final long nodeId;

    NodeProxy(long nodeId, NodeLookup nodeLookup, ThreadToStatementContextBridge statementCtxProvider) {
        this.nodeId = nodeId;
        this.nodeLookup = nodeLookup;
        this.statementCtxProvider = statementCtxProvider;
    }

    @Override
    public long getId() {
        return this.nodeId;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.nodeLookup.getGraphDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        StatementOperationParts context = this.statementCtxProvider.getCtxForWriting();
        try (StatementState state = this.statementCtxProvider.statementForWriting();){
            context.entityWriteOperations().nodeDelete(state, this.getId());
        }
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager());
    }

    @Override
    public boolean hasRelationship() {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager());
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction dir) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), dir);
    }

    @Override
    public boolean hasRelationship(Direction dir) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), dir);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType ... types) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), types);
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), direction, types);
    }

    @Override
    public boolean hasRelationship(RelationshipType ... types) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), types);
    }

    @Override
    public boolean hasRelationship(Direction direction, RelationshipType ... types) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), direction, types);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), type, dir);
    }

    @Override
    public boolean hasRelationship(RelationshipType type, Direction dir) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), type, dir);
    }

    @Override
    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).getSingleRelationship(this.nodeLookup.getNodeManager(), type, dir);
    }

    private void assertInTransaction() {
        this.statementCtxProvider.assertInTransaction();
    }

    @Override
    public void setProperty(String key, Object value) {
        StatementOperationParts context = this.statementCtxProvider.getCtxForWriting();
        StatementState state = this.statementCtxProvider.statementForWriting();
        boolean success = false;
        try {
            long propertyKeyId = context.keyWriteOperations().propertyKeyGetOrCreateForName(state, key);
            context.entityWriteOperations().nodeSetProperty(state, this.nodeId, Property.property(propertyKeyId, value));
            success = true;
        }
        catch (PropertyKeyIdNotFoundException e) {
            throw new ThisShouldNotHappenError("Stefan/Jake", "A property key id disappeared under our feet");
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
        catch (SchemaKernelException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            state.close();
            if (!success) {
                this.nodeLookup.getNodeManager().setRollbackOnly();
            }
        }
    }

    @Override
    public Object removeProperty(String key) throws NotFoundException {
        StatementOperationParts context = this.statementCtxProvider.getCtxForWriting();
        try (StatementState state = this.statementCtxProvider.statementForWriting();){
            long propertyKeyId = context.keyWriteOperations().propertyKeyGetOrCreateForName(state, key);
            Object object = context.entityWriteOperations().nodeRemoveProperty(state, this.nodeId, propertyKeyId).value(null);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        StatementOperationParts context = this.statementCtxProvider.getCtxForReading();
        try (StatementState state = this.statementCtxProvider.statementForReading();){
            long propertyKeyId = context.keyReadOperations().propertyKeyGetForName(state, key);
            Object object = context.entityReadOperations().nodeGetProperty(state, this.nodeId, propertyKeyId).value(defaultValue);
            return object;
        }
    }

    @Override
    public Iterable<Object> getPropertyValues() {
        StatementOperationParts context = this.statementCtxProvider.getCtxForReading();
        try (StatementState state = this.statementCtxProvider.statementForReading();){
            Set<Object> set = IteratorUtil.asSet(Iterables.map(new Function<Property, Object>(){

                @Override
                public Object apply(Property prop) {
                    try {
                        return prop.value();
                    }
                    catch (PropertyNotFoundException e) {
                        throw new ThisShouldNotHappenError("Jake", "Property key retrieved through kernel API should exist.");
                    }
                }
            }, context.entityReadOperations().nodeGetAllProperties(state, this.getId())));
            return set;
        }
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        StatementOperationParts context = this.statementCtxProvider.getCtxForReading();
        try (StatementState state = this.statementCtxProvider.statementForReading();){
            ArrayList<String> keys = new ArrayList<String>();
            PrimitiveLongIterator keyIds = context.entityReadOperations().nodeGetPropertyKeys(state, this.getId());
            while (keyIds.hasNext()) {
                keys.add(context.keyReadOperations().propertyKeyGetName(state, keyIds.next()));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
    }

    @Override
    public Object getProperty(String key) throws NotFoundException {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        StatementOperationParts context = this.statementCtxProvider.getCtxForReading();
        try (StatementState state = this.statementCtxProvider.statementForReading();){
            long propertyKeyId = context.keyReadOperations().propertyKeyGetForName(state, key);
            Object object = context.entityReadOperations().nodeGetProperty(state, this.nodeId, propertyKeyId).value();
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        StatementOperationParts context = this.statementCtxProvider.getCtxForReading();
        try (StatementState state = this.statementCtxProvider.statementForReading();){
            long propertyKeyId = context.keyReadOperations().propertyKeyGetForName(state, key);
            boolean bl = context.entityReadOperations().nodeHasProperty(state, this.nodeId, propertyKeyId);
            return bl;
        }
    }

    public int compareTo(Object node) {
        long theirId;
        Node n = (Node)node;
        long ourId = this.getId();
        if (ourId < (theirId = n.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof Node && this.getId() == ((Node)o).getId();
    }

    public int hashCode() {
        return (int)(this.nodeId >>> 32 ^ this.nodeId);
    }

    public String toString() {
        return "Node[" + this.getId() + "]";
    }

    @Override
    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId, LockType.WRITE).createRelationshipTo(this.nodeLookup.getNodeManager(), this, otherNode, type);
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
        this.assertInTransaction();
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{relationshipType, direction});
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
        this.assertInTransaction();
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{firstRelationshipType, firstDirection, secondRelationshipType, secondDirection});
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
        this.assertInTransaction();
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, relationshipTypesAndDirections);
    }

    @Override
    public void addLabel(Label label) {
        StatementOperationParts context = this.statementCtxProvider.getCtxForWriting();
        try (StatementState state = this.statementCtxProvider.statementForWriting();){
            context.entityWriteOperations().nodeAddLabel(state, this.getId(), context.keyWriteOperations().labelGetOrCreateForName(state, label.name()));
        }
    }

    @Override
    public void removeLabel(Label label) {
        StatementOperationParts context = this.statementCtxProvider.getCtxForWriting();
        try (StatementState state = this.statementCtxProvider.statementForWriting();){
            long labelId = context.keyReadOperations().labelGetForName(state, label.name());
            context.entityWriteOperations().nodeRemoveLabel(state, this.getId(), labelId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasLabel(Label label) {
        StatementOperationParts context = this.statementCtxProvider.getCtxForReading();
        try (StatementState state = this.statementCtxProvider.statementForReading();){
            boolean bl = context.entityReadOperations().nodeHasLabel(state, this.getId(), context.keyReadOperations().labelGetForName(state, label.name()));
            return bl;
        }
    }

    @Override
    public ResourceIterable<Label> getLabels() {
        return new ResourceIterable<Label>(){

            @Override
            public ResourceIterator<Label> iterator() {
                PrimitiveLongIterator labels;
                final StatementOperationParts context = NodeProxy.this.statementCtxProvider.getCtxForReading();
                final StatementState state = NodeProxy.this.statementCtxProvider.statementForReading();
                try {
                    labels = context.entityReadOperations().nodeGetLabels(state, NodeProxy.this.getId());
                }
                catch (EntityNotFoundException e) {
                    state.close();
                    throw new NotFoundException("No node with id " + NodeProxy.this.getId() + " found.", e);
                }
                return NodeProxy.this.nodeLookup.getCleanupService().resourceIterator(Iterables.map(new FunctionFromPrimitiveLong<Label>(){

                    @Override
                    public Label apply(long labelId) {
                        try {
                            return DynamicLabel.label(context.keyReadOperations().labelGetName(state, labelId));
                        }
                        catch (LabelNotFoundKernelException e) {
                            throw new ThisShouldNotHappenError("Mattias", "Listed labels for node " + NodeProxy.this.nodeId + ", but the returned label " + labelId + " doesn't exist anymore");
                        }
                    }
                }, labels), state);
            }
        };
    }

    public static interface NodeLookup {
        public NodeImpl lookup(long var1);

        public GraphDatabaseService getGraphDatabase();

        public NodeManager getNodeManager();

        public CleanupService getCleanupService();

        public NodeImpl lookup(long var1, LockType var3);
    }
}

