/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Set;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.DiffSets;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.state.NodeState;

public interface TxState {
    public boolean hasChanges();

    public void accept(Visitor var1);

    public Iterable<NodeState> nodeStates();

    public DiffSets<Long> labelStateNodeDiffSets(long var1);

    public DiffSets<Long> nodeStateLabelDiffSets(long var1);

    public DiffSets<Property> nodePropertyDiffSets(long var1);

    public DiffSets<Property> relationshipPropertyDiffSets(long var1);

    public DiffSets<Property> graphPropertyDiffSets();

    public Set<Long> nodesWithLabelAdded(long var1);

    public DiffSets<Long> nodesWithLabelChanged(long var1);

    public DiffSets<Long> nodesDeletedInTx();

    public boolean nodeIsAddedInThisTx(long var1);

    public boolean nodeIsDeletedInThisTx(long var1);

    public DiffSets<Long> nodesWithChangedProperty(long var1, Object var3);

    public boolean relationshipIsAddedInThisTx(long var1);

    public boolean relationshipIsDeletedInThisTx(long var1);

    public UpdateTriState labelState(long var1, long var3);

    public void relationshipDoDelete(long var1);

    public void nodeDoDelete(long var1);

    public void nodeDoReplaceProperty(long var1, Property var3, Property var4) throws PropertyNotFoundException, EntityNotFoundException;

    public void relationshipDoReplaceProperty(long var1, Property var3, Property var4) throws PropertyNotFoundException, EntityNotFoundException;

    public void graphDoReplaceProperty(Property var1, Property var2) throws PropertyNotFoundException;

    public void nodeDoRemoveProperty(long var1, Property var3) throws PropertyNotFoundException, EntityNotFoundException;

    public void relationshipDoRemoveProperty(long var1, Property var3) throws PropertyNotFoundException, EntityNotFoundException;

    public void graphDoRemoveProperty(Property var1) throws PropertyNotFoundException;

    public void nodeDoAddLabel(long var1, long var3);

    public void nodeDoRemoveLabel(long var1, long var3);

    public DiffSets<IndexDescriptor> indexDiffSetsByLabel(long var1);

    public DiffSets<IndexDescriptor> constraintIndexDiffSetsByLabel(long var1);

    public DiffSets<IndexDescriptor> indexChanges();

    public DiffSets<IndexDescriptor> constraintIndexChanges();

    public Iterable<IndexDescriptor> constraintIndexesCreatedInTx();

    public DiffSets<UniquenessConstraint> constraintsChanges();

    public DiffSets<UniquenessConstraint> constraintsChangesForLabel(long var1);

    public DiffSets<UniquenessConstraint> constraintsChangesForLabelAndProperty(long var1, long var3);

    public void indexRuleDoAdd(IndexDescriptor var1);

    public void constraintIndexRuleDoAdd(IndexDescriptor var1);

    public void indexDoDrop(IndexDescriptor var1);

    public void constraintIndexDoDrop(IndexDescriptor var1);

    public void constraintDoAdd(UniquenessConstraint var1, long var2);

    public void constraintDoDrop(UniquenessConstraint var1);

    public boolean constraintDoUnRemove(UniquenessConstraint var1);

    public static interface Visitor {
        public void visitNodeLabelChanges(long var1, Set<Long> var3, Set<Long> var4);

        public void visitAddedIndex(IndexDescriptor var1, boolean var2);

        public void visitRemovedIndex(IndexDescriptor var1, boolean var2);

        public void visitAddedConstraint(UniquenessConstraint var1, long var2);

        public void visitRemovedConstraint(UniquenessConstraint var1);
    }

    public static interface IdGeneration {
        public long newNodeId();

        public long newRelationshipId();
    }

    public static interface Holder {
        public TxState txState();

        public boolean hasTxState();

        public boolean hasTxStateWithChanges();
    }

    public static enum UpdateTriState {
        ADDED{

            @Override
            public boolean isTouched() {
                return true;
            }

            @Override
            public boolean isAdded() {
                return true;
            }
        }
        ,
        REMOVED{

            @Override
            public boolean isTouched() {
                return true;
            }

            @Override
            public boolean isAdded() {
                return false;
            }
        }
        ,
        UNTOUCHED{

            @Override
            public boolean isTouched() {
                return false;
            }

            @Override
            public boolean isAdded() {
                throw new UnsupportedOperationException("Cannot convert an UNTOUCHED UpdateTriState to a boolean");
            }
        };


        public abstract boolean isTouched();

        public abstract boolean isAdded();
    }
}

