/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.DiffSets;
import org.neo4j.kernel.impl.api.state.OldTxStateBridge;
import org.neo4j.kernel.impl.core.GraphPropertiesImpl;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.core.WritableTransactionState;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.util.ArrayMap;

public class OldTxStateBridgeImpl
implements OldTxStateBridge {
    private final NodeManager nodeManager;
    private final TransactionState state;

    public OldTxStateBridgeImpl(NodeManager nodeManager, TransactionState transactionState) {
        this.nodeManager = nodeManager;
        this.state = transactionState;
    }

    @Override
    public DiffSets<Long> getNodesWithChangedProperty(long propertyKey, Object value) {
        DiffSets<Long> diff = new DiffSets<Long>();
        Iterable<WritableTransactionState.CowNodeElement> changedNodes = this.state.getChangedNodes();
        for (WritableTransactionState.CowNodeElement changedNode : changedNodes) {
            ArrayMap propAddMap;
            ArrayMap propRmMap = changedNode.getPropertyRemoveMap(false);
            if (propRmMap != null) {
                for (PropertyData propertyData : propRmMap.values()) {
                    if ((long)propertyData.getIndex() != propertyKey || !propertyData.getValue().equals(value)) continue;
                    diff.remove(changedNode.getId());
                }
            }
            if (changedNode.isDeleted() || (propAddMap = changedNode.getPropertyAddMap(false)) == null) continue;
            for (PropertyData propertyData : propAddMap.values()) {
                if ((long)propertyData.getIndex() != propertyKey) continue;
                if (propertyData.getValue().equals(value)) {
                    diff.add(changedNode.getId());
                    continue;
                }
                diff.remove(changedNode.getId());
            }
        }
        return diff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNode(long nodeId) {
        NodeImpl node = this.nodeManager.getNodeForProxy(nodeId, null);
        boolean success = false;
        try {
            ArrayMap<Integer, PropertyData> skipMap = this.state.getOrCreateCowPropertyRemoveMap(node);
            ArrayMap<Integer, PropertyData> removedProps = this.nodeManager.deleteNode(node, this.state);
            if (removedProps.size() > 0) {
                for (Integer index : removedProps.keySet()) {
                    skipMap.put(index, removedProps.get(index));
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                this.nodeManager.setRollbackOnly();
            }
        }
    }

    @Override
    public boolean nodeIsAddedInThisTx(long nodeId) {
        return this.state.getCreatedNodes().contains(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRelationship(long relationshipId) {
        RelationshipImpl relationship = this.nodeManager.getRelationshipForProxy(relationshipId, null);
        boolean success = false;
        try {
            ArrayMap<Integer, PropertyData> skipMap = this.state.getOrCreateCowPropertyRemoveMap(relationship);
            ArrayMap<Integer, PropertyData> removedProps = this.nodeManager.deleteRelationship(relationship, this.state);
            if (removedProps.size() > 0) {
                for (Integer index : removedProps.keySet()) {
                    skipMap.put(index, removedProps.get(index));
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                this.nodeManager.setRollbackOnly();
            }
        }
    }

    @Override
    public boolean relationshipIsAddedInThisTx(long relationshipId) {
        return this.state.getCreatedRelationships().contains(relationshipId);
    }

    @Override
    public boolean hasChanges() {
        return this.state.hasChanges();
    }

    @Override
    public void nodeSetProperty(long nodeId, PropertyData property) {
        NodeImpl node = this.nodeManager.getNodeForProxy(nodeId, null);
        this.state.getOrCreateCowPropertyAddMap(node).put(property.getIndex(), property);
        ArrayMap<Integer, PropertyData> removed = this.state.getCowPropertyRemoveMap(node);
        if (removed != null) {
            removed.remove(property.getIndex());
        }
    }

    @Override
    public void relationshipSetProperty(long relationshipId, PropertyData property) {
        RelationshipImpl relationship = this.nodeManager.getRelationshipForProxy(relationshipId, null);
        this.state.getOrCreateCowPropertyAddMap(relationship).put(property.getIndex(), property);
        ArrayMap<Integer, PropertyData> removed = this.state.getCowPropertyRemoveMap(relationship);
        if (removed != null) {
            removed.remove(property.getIndex());
        }
    }

    @Override
    public void graphSetProperty(PropertyData property) {
        GraphPropertiesImpl properties = this.nodeManager.getGraphProperties();
        this.state.getOrCreateCowPropertyAddMap(properties).put(property.getIndex(), property);
        ArrayMap<Integer, PropertyData> removed = this.state.getCowPropertyRemoveMap(properties);
        if (removed != null) {
            removed.remove(property.getIndex());
        }
    }

    @Override
    public void nodeRemoveProperty(long nodeId, Property property) {
        NodeImpl node = this.nodeManager.getNodeForProxy(nodeId, null);
        this.state.getOrCreateCowPropertyRemoveMap(node).put((int)property.propertyKeyId(), property.asPropertyDataJustForIntegration());
        ArrayMap<Integer, PropertyData> added = this.state.getCowPropertyAddMap(node);
        if (added != null) {
            added.remove((int)property.propertyKeyId());
        }
    }

    @Override
    public void relationshipRemoveProperty(long relationshipId, Property property) {
        RelationshipImpl relationship = this.nodeManager.getRelationshipForProxy(relationshipId, null);
        this.state.getOrCreateCowPropertyRemoveMap(relationship).put((int)property.propertyKeyId(), property.asPropertyDataJustForIntegration());
        ArrayMap<Integer, PropertyData> added = this.state.getCowPropertyAddMap(relationship);
        if (added != null) {
            added.remove((int)property.propertyKeyId());
        }
    }

    @Override
    public void graphRemoveProperty(Property property) {
        GraphPropertiesImpl properties = this.nodeManager.getGraphProperties();
        this.state.getOrCreateCowPropertyRemoveMap(properties).put((int)property.propertyKeyId(), property.asPropertyDataJustForIntegration());
        ArrayMap<Integer, PropertyData> added = this.state.getCowPropertyAddMap(properties);
        if (added != null) {
            added.remove((int)property.propertyKeyId());
        }
    }
}

