/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Iterator;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.StatementOperationParts;
import org.neo4j.kernel.api.operations.StatementState;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;

public class RemoveOrphanConstraintIndexesOnStartup {
    private final AbstractTransactionManager txManager;
    private final StringLogger log;
    private final ThreadToStatementContextBridge ctxProvider;

    public RemoveOrphanConstraintIndexesOnStartup(AbstractTransactionManager txManager, ThreadToStatementContextBridge ctxProvider, Logging logging) {
        this.txManager = txManager;
        this.ctxProvider = ctxProvider;
        this.log = logging.getMessagesLog(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform() {
        try {
            this.txManager.begin(ForceMode.unforced);
            boolean success = false;
            KernelTransaction tx = null;
            try {
                tx = this.txManager.getKernelTransaction();
                StatementOperationParts context = this.ctxProvider.getCtxForWriting();
                try (StatementState state = tx.newStatementState();){
                    Iterator<IndexDescriptor> indexes = context.schemaReadOperations().uniqueIndexesGetAll(state);
                    while (indexes.hasNext()) {
                        IndexDescriptor index = indexes.next();
                        if (context.schemaReadOperations().indexGetOwningUniquenessConstraintId(state, index) != null) continue;
                        context.schemaWriteOperations().uniqueIndexDrop(state, index);
                    }
                }
                success = true;
            }
            finally {
                if (tx != null) {
                    if (success) {
                        tx.commit();
                    } else {
                        tx.rollback();
                    }
                } else {
                    this.txManager.rollback();
                }
            }
        }
        catch (Throwable e) {
            this.log.error("Failed to execute orphan index checking transaction.", e);
        }
    }
}

