/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.neo4j.helpers.FutureAdapter;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.ValueGetter;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;

public class IndexPopulationJob
implements Runnable {
    private final IndexStoreView storeView;
    private final Queue<NodePropertyUpdate> queue = new ConcurrentLinkedQueue<NodePropertyUpdate>();
    private final IndexDescriptor descriptor;
    private final IndexPopulator populator;
    private final FlippableIndexProxy flipper;
    private final UpdateableSchemaState updateableSchemaState;
    private final StringLogger log;
    private final CountDownLatch doneSignal = new CountDownLatch(1);
    private volatile StoreScan<IndexPopulationFailedKernelException> storeScan;
    private volatile boolean cancelled;
    private final SchemaIndexProvider.Descriptor providerDescriptor;

    public IndexPopulationJob(IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, IndexPopulator populator, FlippableIndexProxy flipper, IndexStoreView storeView, UpdateableSchemaState updateableSchemaState, Logging logging) {
        this.descriptor = descriptor;
        this.providerDescriptor = providerDescriptor;
        this.populator = populator;
        this.flipper = flipper;
        this.storeView = storeView;
        this.updateableSchemaState = updateableSchemaState;
        this.log = logging.getMessagesLog(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean success = false;
        Throwable failureCause = null;
        try {
            this.log.info(String.format("Index population started for label id %d on property id %d", this.descriptor.getLabelId(), this.descriptor.getPropertyKeyId()));
            this.log.flush();
            this.populator.create();
            this.indexAllNodes();
            if (this.cancelled) {
                return;
            }
            Callable<Void> duringFlip = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    IndexPopulationJob.this.populateFromQueueIfAvailable(Long.MAX_VALUE);
                    IndexPopulationJob.this.populator.close(true);
                    IndexPopulationJob.this.updateableSchemaState.clear();
                    return null;
                }
            };
            this.flipper.flip(duringFlip, new FailedIndexProxyFactory(){

                @Override
                public IndexProxy create(Throwable failure) {
                    return new FailedIndexProxy(IndexPopulationJob.this.descriptor, IndexPopulationJob.this.providerDescriptor, IndexPopulationJob.this.populator, IndexPopulationFailure.failure(failure));
                }
            });
            success = true;
            this.log.info(String.format("Index population completed for label id %d on property id %d, index is now online.", this.descriptor.getLabelId(), this.descriptor.getPropertyKeyId()));
            this.log.flush();
            return;
        }
        catch (Throwable t) {
            Throwable cause;
            if (t instanceof IndexPopulationFailedKernelException && (cause = t.getCause()) instanceof IndexEntryConflictException) {
                t = cause;
            }
            failureCause = t;
            if (!(t instanceof IndexEntryConflictException)) {
                this.log.error("Failed to populate index.", t);
                this.log.flush();
            }
            this.flipper.flipTo(new FailedIndexProxy(this.descriptor, this.providerDescriptor, this.populator, IndexPopulationFailure.failure(t)));
            return;
        }
        finally {
            try {
                if (!success) {
                    if (failureCause != null) {
                        this.populator.markAsFailed(IndexPopulationFailure.failure(failureCause).asString());
                    }
                    this.populator.close(false);
                }
            }
            catch (Throwable e) {
                this.log.warn("Unable to close failed populator", e);
                this.log.flush();
            }
            finally {
                this.doneSignal.countDown();
            }
        }
    }

    private void indexAllNodes() throws IndexPopulationFailedKernelException {
        this.storeScan = this.storeView.visitNodesWithPropertyAndLabel(this.descriptor, new Visitor<NodePropertyUpdate, IndexPopulationFailedKernelException>(){

            @Override
            public boolean visit(NodePropertyUpdate update) throws IndexPopulationFailedKernelException {
                try {
                    IndexPopulationJob.this.populator.add(update.getNodeId(), update.getValueAfter());
                    IndexPopulationJob.this.populateFromQueueIfAvailable(update.getNodeId());
                }
                catch (Exception conflict) {
                    throw new IndexPopulationFailedKernelException(IndexPopulationJob.this.descriptor, (Throwable)conflict);
                }
                return false;
            }
        });
        this.storeScan.run();
    }

    private void populateFromQueueIfAvailable(final long highestIndexedNodeId) throws IndexEntryConflictException, IOException {
        if (!this.queue.isEmpty()) {
            Predicate<NodePropertyUpdate> hasBeenIndexed = new Predicate<NodePropertyUpdate>(){

                @Override
                public boolean accept(NodePropertyUpdate item) {
                    return item.getNodeId() <= highestIndexedNodeId;
                }
            };
            this.populator.update(Iterables.filter(hasBeenIndexed, this.queue));
        }
    }

    public Future<Void> cancel() {
        if (this.storeScan != null) {
            this.cancelled = true;
            this.storeScan.stop();
        }
        return FutureAdapter.latchGuardedValue(ValueGetter.NO_VALUE, this.doneSignal);
    }

    public void update(Iterable<NodePropertyUpdate> updates) {
        for (NodePropertyUpdate update : updates) {
            this.queue.add(update);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[populator:" + this.populator + ",descriptor:" + this.descriptor + "]";
    }

    public void awaitCompletion() throws InterruptedException {
        this.doneSignal.await();
    }
}

