/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyKeyNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.operations.AuxiliaryStoreOperations;
import org.neo4j.kernel.api.operations.EntityReadOperations;
import org.neo4j.kernel.api.operations.EntityWriteOperations;
import org.neo4j.kernel.api.operations.KeyReadOperations;
import org.neo4j.kernel.api.operations.KeyWriteOperations;
import org.neo4j.kernel.api.operations.SchemaReadOperations;
import org.neo4j.kernel.api.operations.StatementState;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.AbstractPrimitiveLongIterator;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.api.SchemaStorage;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;
import org.neo4j.kernel.impl.persistence.PersistenceManager;

public class StoreStatementOperations
implements KeyReadOperations,
KeyWriteOperations,
EntityReadOperations,
EntityWriteOperations,
SchemaReadOperations,
AuxiliaryStoreOperations {
    private static final Function<UniquenessConstraintRule, UniquenessConstraint> UNIQUENESS_CONSTRAINT_TO_RULE = new Function<UniquenessConstraintRule, UniquenessConstraint>(){

        @Override
        public UniquenessConstraint apply(UniquenessConstraintRule rule) {
            return new UniquenessConstraint(rule.getLabel(), rule.getPropertyKey());
        }
    };
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final NeoStore neoStore;
    private final IndexingService indexService;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final PropertyStore propertyStore;
    private final SchemaStorage schemaStorage;
    private final PersistenceManager persistenceManager;
    private static final Predicate<SchemaRule> INDEX_RULES = new Predicate<SchemaRule>(){

        @Override
        public boolean accept(SchemaRule rule) {
            return rule.getKind() == SchemaRule.Kind.INDEX_RULE;
        }
    };
    private static final Predicate<SchemaRule> CONSTRAINT_INDEX_RULES = new Predicate<SchemaRule>(){

        @Override
        public boolean accept(SchemaRule rule) {
            return rule.getKind() == SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
        }
    };

    public StoreStatementOperations(PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, SchemaStorage schemaStorage, NeoStore neoStore, PersistenceManager persistenceManager, IndexingService indexService) {
        this.schemaStorage = schemaStorage;
        assert (neoStore != null) : "No neoStore provided";
        this.indexService = indexService;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
        this.neoStore = neoStore;
        this.nodeStore = neoStore.getNodeStore();
        this.relationshipStore = neoStore.getRelationshipStore();
        this.propertyStore = neoStore.getPropertyStore();
        this.persistenceManager = persistenceManager;
    }

    private UnsupportedOperationException shouldNotManipulateStoreDirectly() {
        throw new UnsupportedOperationException("The storage layer can not be written to directly, you have to go through a transaction.");
    }

    private UnsupportedOperationException shouldNotHaveReachedAllTheWayHere() {
        throw new UnsupportedOperationException("This call should not reach all the way here");
    }

    private UnsupportedOperationException shouldCallAuxiliaryInstead() {
        return new UnsupportedOperationException("This shouldn't be called directly, but instead to an appropriate method in the " + AuxiliaryStoreOperations.class.getSimpleName() + " interface");
    }

    @Override
    public long labelGetOrCreateForName(StatementState state, String label) throws SchemaKernelException {
        try {
            return this.labelTokenHolder.getOrCreateId(label);
        }
        catch (TransactionFailureException e) {
            if (e.getCause() != null && e.getCause() instanceof UnderlyingStorageException && e.getCause().getMessage().equals("Id capacity exceeded")) {
                throw new TooManyLabelsException(e);
            }
            throw e;
        }
    }

    @Override
    public long labelGetForName(StatementState state, String label) throws LabelNotFoundKernelException {
        try {
            return this.labelTokenHolder.getIdByName(label);
        }
        catch (TokenNotFoundException e) {
            throw new LabelNotFoundKernelException(label, e);
        }
    }

    @Override
    public boolean nodeHasLabel(StatementState state, long nodeId, long labelId) {
        try {
            return IteratorUtil.contains(this.nodeGetLabels(state, nodeId), labelId);
        }
        catch (InvalidRecordException e) {
            return false;
        }
    }

    @Override
    public PrimitiveLongIterator nodeGetLabels(StatementState state, long nodeId) {
        try {
            return IteratorUtil.asPrimitiveIterator(NodeLabelsField.parseLabelsField(this.nodeStore.getRecord(nodeId)).get(this.nodeStore));
        }
        catch (InvalidRecordException e) {
            return IteratorUtil.emptyPrimitiveLongIterator();
        }
    }

    @Override
    public String labelGetName(StatementState state, long labelId) throws LabelNotFoundKernelException {
        try {
            return ((Token)this.labelTokenHolder.getTokenById((int)labelId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new LabelNotFoundKernelException("Label by id " + labelId, e);
        }
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(StatementState state, final long labelId) {
        final NodeStore nodeStore = this.neoStore.getNodeStore();
        final long highestId = nodeStore.getHighestPossibleIdInUse();
        return new AbstractPrimitiveLongIterator(){
            private long id = 0L;
            {
                this.computeNext();
            }

            @Override
            protected void computeNext() {
                while (this.id <= highestId) {
                    NodeRecord node;
                    if (!(node = nodeStore.forceGetRecord(this.id++)).inUse()) continue;
                    for (long label : NodeLabelsField.parseLabelsField(node).get(nodeStore)) {
                        if (label != labelId) continue;
                        this.nextValue = node.getId();
                        this.hasNext = true;
                        return;
                    }
                }
                this.hasNext = false;
            }
        };
    }

    @Override
    public Iterator<Token> labelsGetAllTokens(StatementState state) {
        return this.labelTokenHolder.getAllTokens().iterator();
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(StatementState state, long labelId, long propertyKey) throws SchemaRuleNotFoundException {
        return StoreStatementOperations.descriptor(this.schemaStorage.indexRule(labelId, propertyKey));
    }

    private static IndexDescriptor descriptor(IndexRule ruleRecord) {
        return new IndexDescriptor(ruleRecord.getLabel(), ruleRecord.getPropertyKey());
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(StatementState state, long labelId) {
        return this.getIndexDescriptorsFor(StoreStatementOperations.indexRules(labelId));
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(StatementState state) {
        return this.getIndexDescriptorsFor(INDEX_RULES);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(StatementState state, long labelId) {
        return this.getIndexDescriptorsFor(StoreStatementOperations.constraintIndexRules(labelId));
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll(StatementState state) {
        return this.getIndexDescriptorsFor(CONSTRAINT_INDEX_RULES);
    }

    private static Predicate<SchemaRule> indexRules(final long labelId) {
        return new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.INDEX_RULE;
            }
        };
    }

    private static Predicate<SchemaRule> constraintIndexRules(final long labelId) {
        return new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
            }
        };
    }

    private Iterator<IndexDescriptor> getIndexDescriptorsFor(Predicate<SchemaRule> filter) {
        Iterator<SchemaRule> filtered = Iterables.filter(filter, this.neoStore.getSchemaStore().loadAllSchemaRules());
        return Iterables.map(new Function<SchemaRule, IndexDescriptor>(){

            @Override
            public IndexDescriptor apply(SchemaRule from) {
                return StoreStatementOperations.descriptor((IndexRule)from);
            }
        }, filtered);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(StatementState state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.schemaStorage.indexRule(index.getLabelId(), index.getPropertyKeyId()).getOwningConstraint();
    }

    @Override
    public long indexGetCommittedId(StatementState state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.schemaStorage.indexRule(index.getLabelId(), index.getPropertyKeyId()).getId();
    }

    @Override
    public InternalIndexState indexGetState(StatementState state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getProxyForRule(this.indexId(descriptor)).getState();
    }

    @Override
    public String indexGetFailure(StatementState state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getProxyForRule(this.indexId(descriptor)).getPopulationFailure().asString();
    }

    private long indexId(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        try {
            return this.schemaStorage.indexRule(descriptor.getLabelId(), descriptor.getPropertyKeyId()).getId();
        }
        catch (SchemaRuleNotFoundException e) {
            throw new IndexNotFoundKernelException(e.getMessage(), e);
        }
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(StatementState state, long labelId, final long propertyKeyId) {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, UniquenessConstraintRule.class, labelId, new Predicate<UniquenessConstraintRule>(){

            @Override
            public boolean accept(UniquenessConstraintRule rule) {
                return rule.containsPropertyKeyId(propertyKeyId);
            }
        });
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(StatementState state, long labelId) {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, UniquenessConstraintRule.class, labelId, Predicates.TRUE());
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll(StatementState state) {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, SchemaRule.Kind.UNIQUENESS_CONSTRAINT, Predicates.TRUE());
    }

    @Override
    public long propertyKeyGetOrCreateForName(StatementState state, String propertyKey) {
        return this.propertyKeyTokenHolder.getOrCreateId(propertyKey);
    }

    @Override
    public long propertyKeyGetForName(StatementState state, String propertyKey) throws PropertyKeyNotFoundException {
        try {
            return this.propertyKeyTokenHolder.getIdByName(propertyKey);
        }
        catch (TokenNotFoundException e) {
            throw new PropertyKeyNotFoundException(propertyKey, e);
        }
    }

    @Override
    public String propertyKeyGetName(StatementState state, long propertyKeyId) throws PropertyKeyIdNotFoundException {
        try {
            return ((Token)this.propertyKeyTokenHolder.getTokenById((int)propertyKeyId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new PropertyKeyIdNotFoundException(propertyKeyId, e);
        }
    }

    @Override
    public Iterator<Property> nodeGetAllProperties(StatementState state, long nodeId) throws EntityNotFoundException {
        try {
            return this.loadAllPropertiesOf(this.nodeStore.getRecord(nodeId));
        }
        catch (InvalidRecordException e) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId, e);
        }
    }

    @Override
    public Iterator<Property> relationshipGetAllProperties(StatementState state, long relationshipId) throws EntityNotFoundException {
        try {
            return this.loadAllPropertiesOf(this.relationshipStore.getRecord(relationshipId));
        }
        catch (InvalidRecordException e) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId, e);
        }
    }

    @Override
    public Iterator<Property> graphGetAllProperties(StatementState state) {
        return this.loadAllPropertiesOf(this.neoStore.asRecord());
    }

    private Iterator<Property> loadAllPropertiesOf(PrimitiveRecord primitiveRecord) {
        Collection<PropertyRecord> records = this.propertyStore.getPropertyRecordChain(primitiveRecord.getNextProp());
        if (null == records) {
            return IteratorUtil.emptyIterator();
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        for (PropertyRecord record : records) {
            for (PropertyBlock block : record.getPropertyBlocks()) {
                properties.add(block.getType().readProperty(block.getKeyIndexId(), block, this.propertyStore));
            }
        }
        return properties.iterator();
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexLookup(StatementState state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        return state.indexReaderFactory().newReader(this.indexId(index)).lookup(value);
    }

    @Override
    public void nodeAddStoreProperty(long nodeId, Property property) throws PropertyNotFoundException {
        this.persistenceManager.nodeAddProperty(nodeId, (int)property.propertyKeyId(), property.value());
    }

    @Override
    public void relationshipAddStoreProperty(long relationshipId, Property property) throws PropertyNotFoundException {
        this.persistenceManager.relAddProperty(relationshipId, (int)property.propertyKeyId(), property.value());
    }

    @Override
    public void graphAddStoreProperty(Property property) throws PropertyNotFoundException {
        this.persistenceManager.graphAddProperty((int)property.propertyKeyId(), property.value());
    }

    @Override
    public void nodeChangeStoreProperty(long nodeId, Property previousProperty, Property property) throws PropertyNotFoundException {
        this.persistenceManager.nodeChangeProperty(nodeId, (int)property.propertyKeyId(), property.value());
    }

    @Override
    public void relationshipChangeStoreProperty(long relationshipId, Property previousProperty, Property property) throws PropertyNotFoundException {
        this.persistenceManager.relChangeProperty(relationshipId, (int)property.propertyKeyId(), property.value());
    }

    @Override
    public void graphChangeStoreProperty(Property previousProperty, Property property) throws PropertyNotFoundException {
        this.persistenceManager.graphChangeProperty((int)property.propertyKeyId(), property.value());
    }

    @Override
    public void nodeRemoveStoreProperty(long nodeId, Property property) {
        this.persistenceManager.nodeRemoveProperty(nodeId, (int)property.propertyKeyId());
    }

    @Override
    public void relationshipRemoveStoreProperty(long relationshipId, Property property) {
        this.persistenceManager.relRemoveProperty(relationshipId, (int)property.propertyKeyId());
    }

    @Override
    public void graphRemoveStoreProperty(Property property) {
        this.persistenceManager.graphRemoveProperty((int)property.propertyKeyId());
    }

    @Override
    public Property nodeSetProperty(StatementState state, long nodeId, Property property) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public Property relationshipSetProperty(StatementState state, long relationshipId, Property property) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public Property graphSetProperty(StatementState state, Property property) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public Property nodeRemoveProperty(StatementState state, long nodeId, long propertyKeyId) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public Property relationshipRemoveProperty(StatementState state, long relationshipId, long propertyKeyId) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public Property graphRemoveProperty(StatementState state, long propertyKeyId) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public void nodeDelete(StatementState state, long nodeId) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public void relationshipDelete(StatementState state, long relationshipId) {
        throw this.shouldCallAuxiliaryInstead();
    }

    @Override
    public void nodeDelete(long nodeId) {
        throw this.shouldNotManipulateStoreDirectly();
    }

    @Override
    public void relationshipDelete(long relationshipId) {
        throw this.shouldNotManipulateStoreDirectly();
    }

    @Override
    public boolean nodeAddLabel(StatementState state, long nodeId, long labelId) throws EntityNotFoundException {
        throw this.shouldNotManipulateStoreDirectly();
    }

    @Override
    public boolean nodeRemoveLabel(StatementState state, long nodeId, long labelId) throws EntityNotFoundException {
        throw this.shouldNotManipulateStoreDirectly();
    }

    @Override
    public Property nodeGetProperty(StatementState state, long nodeId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }

    @Override
    public Property relationshipGetProperty(StatementState state, long relationshipId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }

    @Override
    public Property graphGetProperty(StatementState state, long propertyKeyId) throws PropertyKeyIdNotFoundException {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }

    @Override
    public boolean nodeHasProperty(StatementState state, long nodeId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }

    @Override
    public boolean relationshipHasProperty(StatementState state, long relationshipId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }

    @Override
    public boolean graphHasProperty(StatementState state, long propertyKeyId) throws PropertyKeyIdNotFoundException {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }

    @Override
    public PrimitiveLongIterator nodeGetPropertyKeys(StatementState state, long nodeId) throws EntityNotFoundException {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }

    @Override
    public PrimitiveLongIterator relationshipGetPropertyKeys(StatementState state, long relationshipId) throws EntityNotFoundException {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }

    @Override
    public PrimitiveLongIterator graphGetPropertyKeys(StatementState state) {
        throw this.shouldNotHaveReachedAllTheWayHere();
    }
}

