/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.StatementOperationParts;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.operations.AuxiliaryStoreOperations;
import org.neo4j.kernel.api.operations.StatementState;
import org.neo4j.kernel.api.operations.WritableStatementState;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.SchemaStorage;
import org.neo4j.kernel.impl.api.StoreStatementOperations;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;

public class StoreKernelTransaction
implements KernelTransaction {
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final AbstractTransactionManager transactionManager;
    private final NeoStore neoStore;
    private final IndexingService indexingService;
    private final LabelTokenHolder labelTokenHolder;
    private final PersistenceManager persistenceManager;

    public StoreKernelTransaction(AbstractTransactionManager transactionManager, PersistenceManager persistenceManager, PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, NeoStore neoStore, IndexingService indexingService) {
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
        this.transactionManager = transactionManager;
        this.persistenceManager = persistenceManager;
        this.neoStore = neoStore;
        this.indexingService = indexingService;
    }

    @Override
    public StatementOperationParts newStatementOperations() {
        StoreStatementOperations context = new StoreStatementOperations(this.propertyKeyTokenHolder, this.labelTokenHolder, new SchemaStorage(this.neoStore.getSchemaStore()), this.neoStore, this.persistenceManager, this.indexingService);
        return new StatementOperationParts(context, context, context, context, context, null, null).additionalPart(AuxiliaryStoreOperations.class, context);
    }

    @Override
    public void prepare() {
    }

    @Override
    public void commit() throws TransactionFailureException {
        try {
            this.transactionManager.commit();
        }
        catch (HeuristicMixedException e) {
            throw new TransactionFailureException(e);
        }
        catch (HeuristicRollbackException e) {
            throw new TransactionFailureException(e);
        }
        catch (RollbackException e) {
            throw new TransactionFailureException(e);
        }
        catch (SystemException e) {
            throw new TransactionFailureException(e);
        }
        catch (IllegalStateException e) {
            throw new TransactionFailureException(e);
        }
    }

    @Override
    public void rollback() throws TransactionFailureException {
        try {
            if (this.transactionManager.getTransaction() != null) {
                this.transactionManager.rollback();
            }
        }
        catch (IllegalStateException e) {
            throw new TransactionFailureException(e);
        }
        catch (SecurityException e) {
            throw new TransactionFailureException(e);
        }
        catch (SystemException e) {
            throw new TransactionFailureException(e);
        }
    }

    @Override
    public StatementState newStatementState() {
        WritableStatementState result = new WritableStatementState();
        result.provide(new IndexReaderFactory.Caching(this.indexingService));
        return result;
    }
}

