/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import org.neo4j.kernel.api.operations.StatementState;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.LockHolder;
import org.neo4j.kernel.impl.api.state.TxState;

public abstract class StatementStateOwner {
    private ReferencedStatementState reference;

    public StatementState getStatementState() {
        if (this.reference == null) {
            this.reference = new ReferencedStatementState(this.createStatementState());
        }
        return this.reference.newReference();
    }

    protected abstract StatementState createStatementState();

    public void closeAllStatements() throws IOException {
        if (this.reference != null) {
            this.reference.forceClose();
            this.reference = null;
        }
    }

    private class ReferencedStatementState
    implements StatementState {
        private final StatementState actual;
        private int refCount;

        ReferencedStatementState(StatementState actual) {
            this.actual = actual;
        }

        public void forceClose() throws IOException {
            if (this.refCount > 0) {
                this.refCount = 0;
                this.actual.close();
                StatementStateOwner.this.reference = null;
            }
        }

        public StatementState newReference() {
            ++this.refCount;
            return this;
        }

        @Override
        public void close() {
            if (--this.refCount == 0) {
                this.actual.close();
                StatementStateOwner.this.reference = null;
            }
        }

        @Override
        public LockHolder locks() {
            return this.actual.locks();
        }

        @Override
        public TxState txState() {
            return this.actual.txState();
        }

        @Override
        public boolean hasTxState() {
            return this.actual.hasTxState();
        }

        @Override
        public boolean hasTxStateWithChanges() {
            return this.actual.hasTxStateWithChanges();
        }

        @Override
        public IndexReaderFactory indexReaderFactory() {
            return this.actual.indexReaderFactory();
        }
    }
}

