/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.operations.StatementState;
import org.neo4j.kernel.impl.api.DelegatingKernelTransaction;
import org.neo4j.kernel.impl.api.StatementStateOwner;

public class ReferenceCountingKernelTransaction
extends DelegatingKernelTransaction {
    private StatementStateOwner statementContextOwner = new StatementStateOwner(){

        @Override
        protected StatementState createStatementState() {
            return ReferenceCountingKernelTransaction.this.createOwnedStatementState();
        }
    };

    public ReferenceCountingKernelTransaction(KernelTransaction delegate) {
        super(delegate);
    }

    @Override
    public StatementState newStatementState() {
        return this.statementContextOwner.getStatementState();
    }

    private StatementState createOwnedStatementState() {
        return this.delegate.newStatementState();
    }

    @Override
    public void commit() throws TransactionFailureException {
        try {
            this.statementContextOwner.closeAllStatements();
        }
        catch (IOException e) {
            throw new TransactionFailureException(new RuntimeException("Unable to close open statements.", e));
        }
        this.delegate.commit();
    }

    @Override
    public void rollback() throws TransactionFailureException {
        try {
            this.statementContextOwner.closeAllStatements();
        }
        catch (IOException e) {
            throw new TransactionFailureException(new RuntimeException("Unable to close open statements.", e));
        }
        this.delegate.rollback();
    }
}

