/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import java.util.Set;
import org.neo4j.helpers.Thunk;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.operations.StatementState;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.CacheLoader;
import org.neo4j.kernel.impl.api.CacheUpdateListener;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.api.state.NodeState;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.cache.LockStripedCache;
import org.neo4j.kernel.impl.core.GraphPropertiesImpl;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.RelationshipImpl;

public class PersistenceCache {
    private final CacheUpdateListener NODE_CACHE_SIZE_LISTENER = new CacheUpdateListener(){

        @Override
        public void newSize(Primitive entity, int size) {
            PersistenceCache.this.nodeCache.updateSize((NodeImpl)entity, size);
        }
    };
    private final CacheUpdateListener RELATIONSHIP_CACHE_SIZE_LISTENER = new CacheUpdateListener(){

        @Override
        public void newSize(Primitive entity, int size) {
            PersistenceCache.this.relationshipCache.updateSize((RelationshipImpl)entity, size);
        }
    };
    private final LockStripedCache<NodeImpl> nodeCache;
    private final LockStripedCache<RelationshipImpl> relationshipCache;
    private final Thunk<GraphPropertiesImpl> graphProperties;

    public PersistenceCache(LockStripedCache<NodeImpl> nodeCache, LockStripedCache<RelationshipImpl> relationshipCache, Thunk<GraphPropertiesImpl> graphProperties) {
        this.nodeCache = nodeCache;
        this.relationshipCache = relationshipCache;
        this.graphProperties = graphProperties;
    }

    public boolean nodeHasLabel(StatementState state, long nodeId, long labelId, CacheLoader<Set<Long>> cacheLoader) throws EntityNotFoundException {
        Set<Long> labels = this.getNode(nodeId).getLabels(state, cacheLoader);
        return labels.contains(labelId);
    }

    public Set<Long> nodeGetLabels(StatementState state, long nodeId, CacheLoader<Set<Long>> loader) throws EntityNotFoundException {
        return this.getNode(nodeId).getLabels(state, loader);
    }

    private NodeImpl getNode(long nodeId) throws EntityNotFoundException {
        NodeImpl node = this.nodeCache.get(nodeId);
        if (node == null) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId);
        }
        return node;
    }

    private RelationshipImpl getRelationship(long relationshipId) throws EntityNotFoundException {
        RelationshipImpl relationship = this.relationshipCache.get(relationshipId);
        if (relationship == null) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId);
        }
        return relationship;
    }

    public void apply(TxState state) {
        for (NodeState stateEntity : state.nodeStates()) {
            NodeImpl node = this.nodeCache.getIfCached(stateEntity.getId());
            if (node == null) continue;
            node.commitLabels(stateEntity.labelDiffSets().getAdded(), stateEntity.labelDiffSets().getRemoved());
        }
    }

    public void evictNode(long nodeId) {
        this.nodeCache.remove(nodeId);
    }

    public Iterator<Property> nodeGetProperties(StatementState state, long nodeId, CacheLoader<Iterator<Property>> cacheLoader) throws EntityNotFoundException {
        return this.getNode(nodeId).getProperties(state, cacheLoader, this.NODE_CACHE_SIZE_LISTENER);
    }

    public PrimitiveLongIterator nodeGetPropertyKeys(StatementState state, long nodeId, CacheLoader<Iterator<Property>> cacheLoader) throws EntityNotFoundException {
        return this.getNode(nodeId).getPropertyKeys(state, cacheLoader, this.NODE_CACHE_SIZE_LISTENER);
    }

    public Property nodeGetProperty(StatementState state, long nodeId, long propertyKeyId, CacheLoader<Iterator<Property>> cacheLoader) throws EntityNotFoundException {
        return this.getNode(nodeId).getProperty(state, cacheLoader, this.NODE_CACHE_SIZE_LISTENER, (int)propertyKeyId);
    }

    public Iterator<Property> relationshipGetProperties(StatementState state, long relationshipId, CacheLoader<Iterator<Property>> cacheLoader) throws EntityNotFoundException {
        return this.getRelationship(relationshipId).getProperties(state, cacheLoader, this.RELATIONSHIP_CACHE_SIZE_LISTENER);
    }

    public PrimitiveLongIterator relationshipGetPropertyKeys(StatementState state, long relationshipId, CacheLoader<Iterator<Property>> cacheLoader) throws EntityNotFoundException {
        return this.getRelationship(relationshipId).getPropertyKeys(state, cacheLoader, this.RELATIONSHIP_CACHE_SIZE_LISTENER);
    }

    public Property relationshipGetProperty(StatementState state, long relationshipId, long propertyKeyId, CacheLoader<Iterator<Property>> cacheLoader) throws EntityNotFoundException {
        return this.getRelationship(relationshipId).getProperty(state, cacheLoader, this.RELATIONSHIP_CACHE_SIZE_LISTENER, (int)propertyKeyId);
    }

    public Iterator<Property> graphGetProperties(StatementState state, CacheLoader<Iterator<Property>> cacheLoader) {
        return this.graphProperties.evaluate().getProperties(state, cacheLoader, CacheUpdateListener.NO_UPDATES);
    }

    public PrimitiveLongIterator graphGetPropertyKeys(StatementState state, CacheLoader<Iterator<Property>> cacheLoader) {
        return this.graphProperties.evaluate().getPropertyKeys(state, cacheLoader, CacheUpdateListener.NO_UPDATES);
    }

    public Property graphGetProperty(StatementState state, CacheLoader<Iterator<Property>> cacheLoader, long propertyKeyId) {
        return this.graphProperties.evaluate().getProperty(state, cacheLoader, CacheUpdateListener.NO_UPDATES, (int)propertyKeyId);
    }
}

