/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.StatementOperationParts;
import org.neo4j.kernel.api.operations.StatementState;
import org.neo4j.kernel.api.operations.WritableStatementState;
import org.neo4j.kernel.impl.api.DelegatingKernelTransaction;
import org.neo4j.kernel.impl.api.LockHolder;
import org.neo4j.kernel.impl.api.LockHolderImpl;
import org.neo4j.kernel.impl.api.LockingStatementOperations;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.transaction.LockManager;

public class LockingKernelTransaction
extends DelegatingKernelTransaction {
    private final LockHolder lockHolder;

    public LockingKernelTransaction(KernelTransaction delegate, LockManager lockManager, TransactionManager transactionManager, NodeManager nodeManager) {
        super(delegate);
        try {
            this.lockHolder = new LockHolderImpl(lockManager, transactionManager.getTransaction(), nodeManager);
        }
        catch (SystemException e) {
            throw new TransactionFailureException("Unable to get transaction", e);
        }
    }

    @Override
    public StatementOperationParts newStatementOperations() {
        StatementOperationParts parts = this.delegate.newStatementOperations();
        LockingStatementOperations lockingContext = new LockingStatementOperations(parts.entityWriteOperations(), parts.schemaReadOperations(), parts.schemaWriteOperations(), parts.schemaStateOperations());
        return parts.override(null, null, null, lockingContext, lockingContext, lockingContext, lockingContext, new Object[0]);
    }

    @Override
    public StatementState newStatementState() {
        StatementState statement = super.newStatementState();
        ((WritableStatementState)statement).provide(this.lockHolder);
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws org.neo4j.kernel.api.exceptions.TransactionFailureException {
        try {
            this.delegate.commit();
        }
        finally {
            this.lockHolder.releaseLocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws org.neo4j.kernel.api.exceptions.TransactionFailureException {
        try {
            this.delegate.rollback();
        }
        finally {
            this.lockHolder.releaseLocks();
        }
    }
}

