/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.ConstraintValidatingKernelTransaction;
import org.neo4j.kernel.impl.api.DelegatingKernelTransaction;
import org.neo4j.kernel.impl.api.LockingKernelTransaction;
import org.neo4j.kernel.impl.api.PersistenceCache;
import org.neo4j.kernel.impl.api.ReadOnlyStatementOperations;
import org.neo4j.kernel.impl.api.ReferenceCountingKernelTransaction;
import org.neo4j.kernel.impl.api.SchemaCache;
import org.neo4j.kernel.impl.api.SchemaStorage;
import org.neo4j.kernel.impl.api.StateHandlingKernelTransaction;
import org.neo4j.kernel.impl.api.StoreKernelTransaction;
import org.neo4j.kernel.impl.api.Transactor;
import org.neo4j.kernel.impl.api.UniquenessConstraintStoppingKernelTransaction;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.constraints.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.DataSourceRegistrationListener;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class Kernel
extends LifecycleAdapter
implements KernelAPI {
    private final AbstractTransactionManager transactionManager;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final PersistenceManager persistenceManager;
    private final XaDataSourceManager dataSourceManager;
    private final LockManager lockManager;
    private final DependencyResolver dependencyResolver;
    private final UpdateableSchemaState schemaState;
    private final boolean highlyAvailableInstance;
    private IndexingService indexService;
    private NeoStore neoStore;
    private NodeManager nodeManager;
    private PersistenceCache persistenceCache;
    private boolean isShutdown = false;
    private StatementOperationParts statementOperations;
    private StatementOperationParts readOnlyStatementOperations;
    private SchemaCache schemaCache;
    private SchemaIndexProviderMap providerMap = null;

    public Kernel(AbstractTransactionManager transactionManager, PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, PersistenceManager persistenceManager, XaDataSourceManager dataSourceManager, LockManager lockManager, UpdateableSchemaState schemaState, DependencyResolver dependencyResolver, boolean highlyAvailable) {
        this.transactionManager = transactionManager;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
        this.persistenceManager = persistenceManager;
        this.dataSourceManager = dataSourceManager;
        this.lockManager = lockManager;
        this.dependencyResolver = dependencyResolver;
        this.schemaState = schemaState;
        this.highlyAvailableInstance = highlyAvailable;
    }

    @Override
    public void start() throws Throwable {
        this.nodeManager = this.dependencyResolver.resolveDependency(NodeManager.class);
        this.dataSourceManager.addDataSourceRegistrationListener(XaDataSourceManager.neoStoreListener(new DataSourceRegistrationListener(){

            @Override
            public void registeredDataSource(XaDataSource ds) {
                NeoStoreXaDataSource neoDataSource = (NeoStoreXaDataSource)ds;
                Kernel.this.neoStore = neoDataSource.getNeoStore();
                Kernel.this.indexService = neoDataSource.getIndexService();
                Kernel.this.providerMap = neoDataSource.getProviderMap();
                Kernel.this.persistenceCache = neoDataSource.getPersistenceCache();
                Kernel.this.schemaCache = neoDataSource.getSchemaCache();
                for (SchemaRule schemaRule : IteratorUtil.loop(Kernel.this.neoStore.getSchemaStore().loadAllSchemaRules())) {
                    Kernel.this.schemaCache.addSchemaRule(schemaRule);
                }
            }

            @Override
            public void unregisteredDataSource(XaDataSource ds) {
                Kernel.this.neoStore = null;
            }
        }));
    }

    @Override
    public void bootstrapAfterRecovery() {
        StatementOperationParts parts;
        this.statementOperations = parts = this.newTransaction().newStatementOperations();
        ReadOnlyStatementOperations readOnlyParts = new ReadOnlyStatementOperations(parts.schemaStateOperations());
        this.readOnlyStatementOperations = parts.override(parts.keyReadOperations(), readOnlyParts, parts.entityReadOperations(), readOnlyParts, parts.schemaReadOperations(), readOnlyParts, readOnlyParts, new Object[0]);
    }

    @Override
    public void stop() throws Throwable {
        this.isShutdown = true;
    }

    @Override
    public KernelTransaction newTransaction() {
        this.checkIfShutdown();
        StoreKernelTransaction storeTransactionContext = new StoreKernelTransaction(this.transactionManager, this.persistenceManager, this.propertyKeyTokenHolder, this.labelTokenHolder, this.neoStore, this.indexService);
        DelegatingKernelTransaction result = new StateHandlingKernelTransaction(storeTransactionContext, new SchemaStorage(this.neoStore.getSchemaStore()), this.transactionManager.getTransactionState(), this.providerMap, this.persistenceCache, this.schemaCache, this.persistenceManager, this.schemaState, new ConstraintIndexCreator(new Transactor(this.transactionManager), this.indexService), this.propertyKeyTokenHolder, this.nodeManager);
        result = new ConstraintValidatingKernelTransaction(result);
        result = new LockingKernelTransaction(result, this.lockManager, this.transactionManager, this.nodeManager);
        if (this.highlyAvailableInstance) {
            result = new UniquenessConstraintStoppingKernelTransaction(result);
        }
        result = new ReferenceCountingKernelTransaction(result);
        return result;
    }

    private void checkIfShutdown() {
        if (this.isShutdown) {
            throw new DatabaseShutdownException();
        }
    }

    @Override
    public StatementOperationParts statementOperations() {
        return this.statementOperations;
    }

    @Override
    public StatementOperationParts readOnlyStatementOperations() {
        return this.readOnlyStatementOperations;
    }
}

