/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import java.util.Set;
import org.neo4j.kernel.impl.api.AbstractPrimitiveLongIterator;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;

public final class DiffApplyingPrimitiveLongIterator
extends AbstractPrimitiveLongIterator {
    private final PrimitiveLongIterator source;
    private final Iterator<?> addedElementsIterator;
    private final Set<?> addedElements;
    private final Set<?> removedElements;
    Phase phase;

    public DiffApplyingPrimitiveLongIterator(PrimitiveLongIterator source, Set<?> addedElements, Set<?> removedElements) {
        this.source = source;
        this.addedElements = addedElements;
        this.addedElementsIterator = addedElements == null ? null : addedElements.iterator();
        this.removedElements = removedElements;
        this.phase = Phase.FILTERED_SOURCE;
        this.computeNext();
    }

    @Override
    protected void computeNext() {
        this.phase.computeNext(this);
    }

    private void computeNextFromSourceAndFilter() {
        this.hasNext = this.source.hasNext();
        while (this.hasNext) {
            this.nextValue = this.source.next();
            if (!(this.removedElements != null && this.removedElements.contains(this.nextValue) || this.addedElements != null && this.addedElements.contains(this.nextValue))) {
                return;
            }
            this.hasNext = this.source.hasNext();
        }
        this.transitionToAddedElements();
    }

    private void transitionToAddedElements() {
        this.phase = this.addedElementsIterator == null ? Phase.NO_ADDED_ELEMENTS : Phase.ADDED_ELEMENTS;
        this.computeNext();
    }

    private void computeNextFromAddedElements() {
        this.hasNext = this.addedElementsIterator.hasNext();
        if (this.hasNext) {
            this.nextValue = (Long)this.addedElementsIterator.next();
        }
    }

    private static enum Phase {
        FILTERED_SOURCE{

            @Override
            void computeNext(DiffApplyingPrimitiveLongIterator self) {
                self.computeNextFromSourceAndFilter();
            }
        }
        ,
        ADDED_ELEMENTS{

            @Override
            void computeNext(DiffApplyingPrimitiveLongIterator self) {
                self.computeNextFromAddedElements();
            }
        }
        ,
        NO_ADDED_ELEMENTS{

            @Override
            void computeNext(DiffApplyingPrimitiveLongIterator self) {
                self.hasNext = false;
            }
        };


        abstract void computeNext(DiffApplyingPrimitiveLongIterator var1);
    }
}

