/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.FullSizeProperty;

class ShortArrayProperty
extends FullSizeProperty {
    private final short[] value;

    ShortArrayProperty(long propertyKeyId, short[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public short[] value() {
        return this.value;
    }

    @Override
    public boolean valueEquals(Object value) {
        if (value instanceof short[]) {
            return Arrays.equals(this.value, (short[])value);
        }
        return this.valueCompare(value, this.value);
    }

    @Override
    int valueHash() {
        return Arrays.hashCode(this.value);
    }

    @Override
    boolean hasEqualValue(FullSizeProperty that) {
        return Arrays.equals(this.value, ((ShortArrayProperty)that).value);
    }
}

