/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyDatas;

final class NoProperty
extends Property {
    private final long propertyKeyId;
    private final EntityType entityType;
    private final long entityId;

    NoProperty(long propertyKeyId, EntityType entityType, long entityId) {
        this.propertyKeyId = propertyKeyId;
        this.entityType = entityType;
        this.entityId = entityId;
    }

    public String toString() {
        return String.format("%s[propertyKeyId=%s, %sId=%s]", this.getClass().getSimpleName(), this.propertyKeyId, this.entityType.name().toLowerCase(), this.entityId);
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof NoProperty && this.propertyKeyId == ((NoProperty)o).propertyKeyId;
    }

    @Override
    public boolean isNoProperty() {
        return true;
    }

    @Override
    public int hashCode() {
        return (int)(this.propertyKeyId ^ this.propertyKeyId >>> 32);
    }

    @Override
    public long propertyKeyId() {
        return this.propertyKeyId;
    }

    @Override
    public boolean valueEquals(Object value) {
        return false;
    }

    @Override
    public Object value(Object defaultValue) {
        return defaultValue;
    }

    @Override
    public String stringValue(String defaultValue) {
        return defaultValue;
    }

    @Override
    public Number numberValue(Number defaultValue) {
        return defaultValue;
    }

    @Override
    public int intValue(int defaultValue) {
        return defaultValue;
    }

    @Override
    public long longValue(long defaultValue) {
        return defaultValue;
    }

    @Override
    public boolean booleanValue(boolean defaultValue) {
        return defaultValue;
    }

    @Override
    public Object value() throws PropertyNotFoundException {
        throw new PropertyNotFoundException(this.propertyKeyId);
    }

    @Override
    public String stringValue() throws PropertyNotFoundException {
        throw new PropertyNotFoundException(this.propertyKeyId);
    }

    @Override
    public boolean booleanValue() throws PropertyNotFoundException {
        throw new PropertyNotFoundException(this.propertyKeyId);
    }

    @Override
    public Number numberValue() throws PropertyNotFoundException {
        throw new PropertyNotFoundException(this.propertyKeyId);
    }

    @Override
    public int intValue() throws PropertyNotFoundException {
        throw new PropertyNotFoundException(this.propertyKeyId);
    }

    @Override
    public long longValue() throws PropertyNotFoundException {
        throw new PropertyNotFoundException(this.propertyKeyId);
    }

    @Override
    @Deprecated
    public PropertyData asPropertyDataJustForIntegration() {
        return PropertyDatas.noProperty(this.propertyKeyId);
    }
}

