/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.FullSizeProperty;

class LongArrayProperty
extends FullSizeProperty {
    private final long[] value;

    LongArrayProperty(long propertyKeyId, long[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public long[] value() {
        return this.value;
    }

    @Override
    public boolean valueEquals(Object value) {
        if (value instanceof long[]) {
            return Arrays.equals(this.value, (long[])value);
        }
        return this.valueCompare(this.value, value);
    }

    @Override
    int valueHash() {
        return Arrays.hashCode(this.value);
    }

    @Override
    boolean hasEqualValue(FullSizeProperty that) {
        return Arrays.equals(this.value, ((LongArrayProperty)that).value);
    }
}

