/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.FullSizeProperty;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyDatas;

final class BigLongProperty
extends FullSizeProperty {
    private final long value;

    BigLongProperty(long propertyKeyId, long value) {
        super(propertyKeyId);
        this.value = value;
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof Long) {
            return this.value == (Long)other;
        }
        return this.valueCompare(this.value, other);
    }

    @Override
    public Long value() {
        return this.value;
    }

    @Override
    public int intValue() {
        throw new ClassCastException(String.format("[%s:long] is not small enough to fit into an int.", this.value));
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    int valueHash() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    boolean hasEqualValue(FullSizeProperty that) {
        return this.value == ((BigLongProperty)that).value;
    }

    @Override
    @Deprecated
    public PropertyData asPropertyDataJustForIntegration() {
        return PropertyDatas.forLong((int)this.propertyKeyId, -1L, this.value);
    }
}

