/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.operations;

import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundException;
import org.neo4j.kernel.api.operations.KeyReadOperations;
import org.neo4j.kernel.api.operations.StatementState;

public class KeyNameLookup {
    private final KeyReadOperations keyReadOperations;
    private final StatementState state;

    public KeyNameLookup(StatementState state, KeyReadOperations context) {
        this.state = state;
        this.keyReadOperations = context;
    }

    public String getLabelName(long labelId) {
        try {
            return this.keyReadOperations.labelGetName(this.state, labelId);
        }
        catch (LabelNotFoundKernelException e) {
            return "[" + labelId + "]";
        }
    }

    public String getPropertyKeyName(long propertyId) {
        try {
            return this.keyReadOperations.propertyKeyGetName(this.state, propertyId);
        }
        catch (PropertyKeyIdNotFoundException e) {
            return "[" + propertyId + "]";
        }
    }
}

