/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.api.StatementOperations;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyKeyNotFoundException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.operations.EntityReadOperations;
import org.neo4j.kernel.api.operations.EntityWriteOperations;
import org.neo4j.kernel.api.operations.KeyReadOperations;
import org.neo4j.kernel.api.operations.KeyWriteOperations;
import org.neo4j.kernel.api.operations.SchemaReadOperations;
import org.neo4j.kernel.api.operations.SchemaStateOperations;
import org.neo4j.kernel.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.api.operations.StatementState;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.core.Token;

public class StatementOperationParts {
    private final KeyReadOperations keyReadOperations;
    private final KeyWriteOperations keyWriteOperations;
    private final EntityReadOperations entityReadOperations;
    private final EntityWriteOperations entityWriteOperations;
    private final SchemaReadOperations schemaReadOperations;
    private final SchemaWriteOperations schemaWriteOperations;
    private final SchemaStateOperations schemaStateOperations;
    private Map<Class, Object> additionalParts;

    public StatementOperationParts(KeyReadOperations keyReadOperations, KeyWriteOperations keyWriteOperations, EntityReadOperations entityReadOperations, EntityWriteOperations entityWriteOperations, SchemaReadOperations schemaReadOperations, SchemaWriteOperations schemaWriteOperations, SchemaStateOperations schemaStateOperations) {
        this.keyReadOperations = keyReadOperations;
        this.keyWriteOperations = keyWriteOperations;
        this.entityReadOperations = entityReadOperations;
        this.entityWriteOperations = entityWriteOperations;
        this.schemaReadOperations = schemaReadOperations;
        this.schemaWriteOperations = schemaWriteOperations;
        this.schemaStateOperations = schemaStateOperations;
    }

    public <T> StatementOperationParts additionalPart(Class<T> cls, T value) {
        if (this.additionalParts == null) {
            this.additionalParts = new HashMap<Class, Object>();
        }
        this.additionalParts.put(cls, value);
        return this;
    }

    public <T> T resolve(Class<T> cls) {
        Object part;
        Object object = part = this.additionalParts != null ? this.additionalParts.get(cls) : null;
        if (part == null) {
            throw new IllegalArgumentException("No part " + cls.getName());
        }
        return (T)part;
    }

    public KeyReadOperations keyReadOperations() {
        return this.checkNotNull(this.keyReadOperations, KeyReadOperations.class);
    }

    public KeyWriteOperations keyWriteOperations() {
        return this.checkNotNull(this.keyWriteOperations, KeyWriteOperations.class);
    }

    public EntityReadOperations entityReadOperations() {
        return this.checkNotNull(this.entityReadOperations, EntityReadOperations.class);
    }

    public EntityWriteOperations entityWriteOperations() {
        return this.checkNotNull(this.entityWriteOperations, EntityWriteOperations.class);
    }

    public SchemaReadOperations schemaReadOperations() {
        return this.checkNotNull(this.schemaReadOperations, SchemaReadOperations.class);
    }

    public SchemaWriteOperations schemaWriteOperations() {
        return this.checkNotNull(this.schemaWriteOperations, SchemaWriteOperations.class);
    }

    public SchemaStateOperations schemaStateOperations() {
        return this.checkNotNull(this.schemaStateOperations, SchemaStateOperations.class);
    }

    public StatementOperationParts override(KeyReadOperations keyReadOperations, KeyWriteOperations keyWriteOperations, EntityReadOperations entityReadOperations, EntityWriteOperations entityWriteOperations, SchemaReadOperations schemaReadOperations, SchemaWriteOperations schemaWriteOperations, SchemaStateOperations schemaStateOperations, Object ... alternatingAdditionalClassAndObject) {
        StatementOperationParts parts = new StatementOperationParts(this.eitherOr(keyReadOperations, this.keyReadOperations, KeyReadOperations.class), this.eitherOr(keyWriteOperations, this.keyWriteOperations, KeyWriteOperations.class), this.eitherOr(entityReadOperations, this.entityReadOperations, EntityReadOperations.class), this.eitherOr(entityWriteOperations, this.entityWriteOperations, EntityWriteOperations.class), this.eitherOr(schemaReadOperations, this.schemaReadOperations, SchemaReadOperations.class), this.eitherOr(schemaWriteOperations, this.schemaWriteOperations, SchemaWriteOperations.class), this.eitherOr(schemaStateOperations, this.schemaStateOperations, SchemaStateOperations.class));
        if (this.additionalParts != null) {
            parts.additionalParts = new HashMap<Class, Object>(this.additionalParts);
        }
        for (int i = 0; i < alternatingAdditionalClassAndObject.length; ++i) {
            parts.additionalPart((Class)alternatingAdditionalClassAndObject[i++], alternatingAdditionalClassAndObject[i]);
        }
        return parts;
    }

    private <T> T checkNotNull(T object, Class<T> cls) {
        if (object == null) {
            throw new IllegalStateException("No part of type " + cls.getSimpleName() + " assigned");
        }
        return object;
    }

    private <T> T eitherOr(T first, T other, Class<T> cls) {
        return first != null ? first : other;
    }

    @Deprecated
    public StatementOperations asStatementOperations() {
        return new StatementOperations(){

            @Override
            public long labelGetForName(StatementState state, String labelName) throws LabelNotFoundKernelException {
                return StatementOperationParts.this.keyReadOperations.labelGetForName(state, labelName);
            }

            @Override
            public String labelGetName(StatementState state, long labelId) throws LabelNotFoundKernelException {
                return StatementOperationParts.this.keyReadOperations.labelGetName(state, labelId);
            }

            @Override
            public long propertyKeyGetForName(StatementState state, String propertyKeyName) throws PropertyKeyNotFoundException {
                return StatementOperationParts.this.keyReadOperations.propertyKeyGetForName(state, propertyKeyName);
            }

            @Override
            public String propertyKeyGetName(StatementState state, long propertyKeyId) throws PropertyKeyIdNotFoundException {
                return StatementOperationParts.this.keyReadOperations.propertyKeyGetName(state, propertyKeyId);
            }

            @Override
            public Iterator<Token> labelsGetAllTokens(StatementState state) {
                return StatementOperationParts.this.keyReadOperations.labelsGetAllTokens(state);
            }

            @Override
            public long labelGetOrCreateForName(StatementState state, String labelName) throws SchemaKernelException {
                return StatementOperationParts.this.keyWriteOperations.labelGetOrCreateForName(state, labelName);
            }

            @Override
            public long propertyKeyGetOrCreateForName(StatementState state, String propertyKeyName) throws SchemaKernelException {
                return StatementOperationParts.this.keyWriteOperations.propertyKeyGetOrCreateForName(state, propertyKeyName);
            }

            @Override
            public PrimitiveLongIterator nodesGetForLabel(StatementState state, long labelId) {
                return StatementOperationParts.this.entityReadOperations.nodesGetForLabel(state, labelId);
            }

            @Override
            public PrimitiveLongIterator nodesGetFromIndexLookup(StatementState state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
                return StatementOperationParts.this.entityReadOperations.nodesGetFromIndexLookup(state, index, value);
            }

            @Override
            public boolean nodeHasLabel(StatementState state, long nodeId, long labelId) throws EntityNotFoundException {
                return StatementOperationParts.this.entityReadOperations.nodeHasLabel(state, nodeId, labelId);
            }

            @Override
            public PrimitiveLongIterator nodeGetLabels(StatementState state, long nodeId) throws EntityNotFoundException {
                return StatementOperationParts.this.entityReadOperations.nodeGetLabels(state, nodeId);
            }

            @Override
            public Property nodeGetProperty(StatementState state, long nodeId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
                return StatementOperationParts.this.entityReadOperations.nodeGetProperty(state, nodeId, propertyKeyId);
            }

            @Override
            public Property relationshipGetProperty(StatementState state, long relationshipId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
                return StatementOperationParts.this.entityReadOperations.relationshipGetProperty(state, relationshipId, propertyKeyId);
            }

            @Override
            public Property graphGetProperty(StatementState state, long propertyKeyId) throws PropertyKeyIdNotFoundException {
                return StatementOperationParts.this.entityReadOperations.graphGetProperty(state, propertyKeyId);
            }

            @Override
            public boolean nodeHasProperty(StatementState state, long nodeId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
                return StatementOperationParts.this.entityReadOperations.nodeHasProperty(state, nodeId, propertyKeyId);
            }

            @Override
            public boolean relationshipHasProperty(StatementState state, long relationshipId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
                return StatementOperationParts.this.entityReadOperations.relationshipHasProperty(state, relationshipId, propertyKeyId);
            }

            @Override
            public boolean graphHasProperty(StatementState state, long propertyKeyId) throws PropertyKeyIdNotFoundException {
                return StatementOperationParts.this.entityReadOperations.graphHasProperty(state, propertyKeyId);
            }

            @Override
            public PrimitiveLongIterator nodeGetPropertyKeys(StatementState state, long nodeId) throws EntityNotFoundException {
                return StatementOperationParts.this.entityReadOperations.nodeGetPropertyKeys(state, nodeId);
            }

            @Override
            public Iterator<Property> nodeGetAllProperties(StatementState state, long nodeId) throws EntityNotFoundException {
                return StatementOperationParts.this.entityReadOperations.nodeGetAllProperties(state, nodeId);
            }

            @Override
            public PrimitiveLongIterator relationshipGetPropertyKeys(StatementState state, long relationshipId) throws EntityNotFoundException {
                return StatementOperationParts.this.entityReadOperations.relationshipGetPropertyKeys(state, relationshipId);
            }

            @Override
            public Iterator<Property> relationshipGetAllProperties(StatementState state, long relationshipId) throws EntityNotFoundException {
                return StatementOperationParts.this.entityReadOperations.relationshipGetAllProperties(state, relationshipId);
            }

            @Override
            public PrimitiveLongIterator graphGetPropertyKeys(StatementState state) {
                return StatementOperationParts.this.entityReadOperations.graphGetPropertyKeys(state);
            }

            @Override
            public Iterator<Property> graphGetAllProperties(StatementState state) {
                return StatementOperationParts.this.entityReadOperations.graphGetAllProperties(state);
            }

            @Override
            public void nodeDelete(StatementState state, long nodeId) {
                StatementOperationParts.this.entityWriteOperations.nodeDelete(state, nodeId);
            }

            @Override
            public void relationshipDelete(StatementState state, long relationshipId) {
                StatementOperationParts.this.entityWriteOperations.relationshipDelete(state, relationshipId);
            }

            @Override
            public boolean nodeAddLabel(StatementState state, long nodeId, long labelId) throws EntityNotFoundException {
                return StatementOperationParts.this.entityWriteOperations.nodeAddLabel(state, nodeId, labelId);
            }

            @Override
            public boolean nodeRemoveLabel(StatementState state, long nodeId, long labelId) throws EntityNotFoundException {
                return StatementOperationParts.this.entityWriteOperations.nodeRemoveLabel(state, nodeId, labelId);
            }

            @Override
            public Property nodeSetProperty(StatementState state, long nodeId, Property property) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
                return StatementOperationParts.this.entityWriteOperations.nodeSetProperty(state, nodeId, property);
            }

            @Override
            public Property relationshipSetProperty(StatementState state, long relationshipId, Property property) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
                return StatementOperationParts.this.entityWriteOperations.relationshipSetProperty(state, relationshipId, property);
            }

            @Override
            public Property graphSetProperty(StatementState state, Property property) throws PropertyKeyIdNotFoundException {
                return StatementOperationParts.this.entityWriteOperations.graphSetProperty(state, property);
            }

            @Override
            public Property nodeRemoveProperty(StatementState state, long nodeId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
                return StatementOperationParts.this.entityWriteOperations.nodeRemoveProperty(state, nodeId, propertyKeyId);
            }

            @Override
            public Property relationshipRemoveProperty(StatementState state, long relationshipId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
                return StatementOperationParts.this.entityWriteOperations.relationshipRemoveProperty(state, relationshipId, propertyKeyId);
            }

            @Override
            public Property graphRemoveProperty(StatementState state, long propertyKeyId) throws PropertyKeyIdNotFoundException {
                return StatementOperationParts.this.entityWriteOperations.graphRemoveProperty(state, propertyKeyId);
            }

            @Override
            public IndexDescriptor indexesGetForLabelAndPropertyKey(StatementState state, long labelId, long propertyKey) throws SchemaRuleNotFoundException {
                return StatementOperationParts.this.schemaReadOperations.indexesGetForLabelAndPropertyKey(state, labelId, propertyKey);
            }

            @Override
            public Iterator<IndexDescriptor> indexesGetForLabel(StatementState state, long labelId) {
                return StatementOperationParts.this.schemaReadOperations.indexesGetForLabel(state, labelId);
            }

            @Override
            public Iterator<IndexDescriptor> indexesGetAll(StatementState state) {
                return StatementOperationParts.this.schemaReadOperations.indexesGetAll(state);
            }

            @Override
            public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(StatementState state, long labelId) {
                return StatementOperationParts.this.schemaReadOperations.uniqueIndexesGetForLabel(state, labelId);
            }

            @Override
            public Iterator<IndexDescriptor> uniqueIndexesGetAll(StatementState state) {
                return StatementOperationParts.this.schemaReadOperations.uniqueIndexesGetAll(state);
            }

            @Override
            public InternalIndexState indexGetState(StatementState state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
                return StatementOperationParts.this.schemaReadOperations.indexGetState(state, descriptor);
            }

            @Override
            public String indexGetFailure(StatementState state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
                return StatementOperationParts.this.schemaReadOperations.indexGetFailure(state, descriptor);
            }

            @Override
            public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(StatementState state, long labelId, long propertyKeyId) {
                return StatementOperationParts.this.schemaReadOperations.constraintsGetForLabelAndPropertyKey(state, labelId, propertyKeyId);
            }

            @Override
            public Iterator<UniquenessConstraint> constraintsGetForLabel(StatementState state, long labelId) {
                return StatementOperationParts.this.schemaReadOperations.constraintsGetForLabel(state, labelId);
            }

            @Override
            public Iterator<UniquenessConstraint> constraintsGetAll(StatementState state) {
                return StatementOperationParts.this.schemaReadOperations.constraintsGetAll(state);
            }

            @Override
            public Long indexGetOwningUniquenessConstraintId(StatementState state, IndexDescriptor index) throws SchemaRuleNotFoundException {
                return StatementOperationParts.this.schemaReadOperations.indexGetOwningUniquenessConstraintId(state, index);
            }

            @Override
            public long indexGetCommittedId(StatementState state, IndexDescriptor index) throws SchemaRuleNotFoundException {
                return StatementOperationParts.this.schemaReadOperations.indexGetCommittedId(state, index);
            }

            @Override
            public IndexDescriptor indexCreate(StatementState state, long labelId, long propertyKeyId) throws SchemaKernelException {
                return StatementOperationParts.this.schemaWriteOperations.indexCreate(state, labelId, propertyKeyId);
            }

            @Override
            public IndexDescriptor uniqueIndexCreate(StatementState state, long labelId, long propertyKey) throws SchemaKernelException {
                return StatementOperationParts.this.schemaWriteOperations.uniqueIndexCreate(state, labelId, propertyKey);
            }

            @Override
            public void indexDrop(StatementState state, IndexDescriptor descriptor) throws DropIndexFailureException {
                StatementOperationParts.this.schemaWriteOperations.indexDrop(state, descriptor);
            }

            @Override
            public void uniqueIndexDrop(StatementState state, IndexDescriptor descriptor) throws DropIndexFailureException {
                StatementOperationParts.this.schemaWriteOperations.uniqueIndexDrop(state, descriptor);
            }

            @Override
            public UniquenessConstraint uniquenessConstraintCreate(StatementState state, long labelId, long propertyKeyId) throws SchemaKernelException {
                return StatementOperationParts.this.schemaWriteOperations.uniquenessConstraintCreate(state, labelId, propertyKeyId);
            }

            @Override
            public void constraintDrop(StatementState state, UniquenessConstraint constraint) {
                StatementOperationParts.this.schemaWriteOperations.constraintDrop(state, constraint);
            }

            @Override
            public <K, V> V schemaStateGetOrCreate(StatementState state, K key, Function<K, V> creator) {
                return StatementOperationParts.this.schemaStateOperations.schemaStateGetOrCreate(state, key, creator);
            }

            @Override
            public <K> boolean schemaStateContains(StatementState state, K key) {
                return StatementOperationParts.this.schemaStateOperations.schemaStateContains(state, key);
            }
        };
    }
}

