/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.StatementOperationParts;
import org.neo4j.kernel.api.operations.StatementState;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class ThreadToStatementContextBridge
extends LifecycleAdapter {
    protected final KernelAPI kernelAPI;
    private final AbstractTransactionManager txManager;
    private boolean isShutdown = false;

    public ThreadToStatementContextBridge(KernelAPI kernelAPI, AbstractTransactionManager txManager) {
        this.kernelAPI = kernelAPI;
        this.txManager = txManager;
    }

    public StatementOperationParts getCtxForReading() {
        return this.kernelAPI.readOnlyStatementOperations();
    }

    public StatementOperationParts getCtxForWriting() {
        return this.kernelAPI.statementOperations();
    }

    public StatementState statementForReading() {
        return this.statementForReadingAndWriting();
    }

    public StatementState statementForWriting() {
        return this.statementForReadingAndWriting();
    }

    private StatementState statementForReadingAndWriting() {
        this.checkIfShutdown();
        StatementState statement = this.txManager.newStatement();
        if (statement != null) {
            return statement;
        }
        throw new NotInTransactionException();
    }

    @Override
    public void shutdown() throws Throwable {
        this.isShutdown = true;
    }

    private void checkIfShutdown() {
        if (this.isShutdown) {
            throw new DatabaseShutdownException();
        }
    }

    public void assertInTransaction() {
        this.txManager.assertInTransaction();
    }

    public static class ReadOnly
    extends ThreadToStatementContextBridge {
        public ReadOnly(KernelAPI kernelAPI, AbstractTransactionManager txManager) {
            super(kernelAPI, txManager);
        }

        @Override
        public StatementOperationParts getCtxForWriting() {
            return this.kernelAPI.readOnlyStatementOperations();
        }

        @Override
        public StatementOperationParts getCtxForReading() {
            return this.kernelAPI.readOnlyStatementOperations();
        }
    }
}

