/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.BaseConstraintCreator;
import org.neo4j.kernel.IndexCreatorImpl;
import org.neo4j.kernel.IndexDefinitionImpl;
import org.neo4j.kernel.InternalSchemaActions;
import org.neo4j.kernel.PropertyUniqueConstraintDefinition;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.StatementOperationParts;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyKeyNotFoundException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.operations.KeyNameLookup;
import org.neo4j.kernel.api.operations.StatementState;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;

public class SchemaImpl
implements Schema {
    private final ThreadToStatementContextBridge ctxProvider;
    private final InternalSchemaActions actions;

    public SchemaImpl(ThreadToStatementContextBridge ctxProvider) {
        this.ctxProvider = ctxProvider;
        this.actions = new GDBSchemaActions(ctxProvider);
    }

    @Override
    public IndexCreator indexFor(Label label) {
        this.assertInTransaction();
        return new IndexCreatorImpl(this.actions, label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<IndexDefinition> getIndexes(Label label) {
        this.assertInTransaction();
        StatementOperationParts context = this.ctxProvider.getCtxForReading();
        try (StatementState state = this.ctxProvider.statementForReading();){
            ArrayList<IndexDefinition> definitions = new ArrayList<IndexDefinition>();
            long labelId = context.keyReadOperations().labelGetForName(state, label.name());
            this.addDefinitions(definitions, context, state, context.schemaReadOperations().indexesGetForLabel(state, labelId), false);
            this.addDefinitions(definitions, context, state, context.schemaReadOperations().uniqueIndexesGetForLabel(state, labelId), true);
            ArrayList<IndexDefinition> arrayList = definitions;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<IndexDefinition> getIndexes() {
        this.assertInTransaction();
        StatementOperationParts context = this.ctxProvider.getCtxForReading();
        try (StatementState state = this.ctxProvider.statementForReading();){
            ArrayList<IndexDefinition> definitions = new ArrayList<IndexDefinition>();
            this.addDefinitions(definitions, context, state, context.schemaReadOperations().indexesGetAll(state), false);
            this.addDefinitions(definitions, context, state, context.schemaReadOperations().uniqueIndexesGetAll(state), true);
            ArrayList<IndexDefinition> arrayList = definitions;
            return arrayList;
        }
    }

    private void addDefinitions(List<IndexDefinition> definitions, final StatementOperationParts context, final StatementState state, Iterator<IndexDescriptor> indexes, final boolean constraintIndex) {
        IteratorUtil.addToCollection(Iterables.map(new Function<IndexDescriptor, IndexDefinition>(){

            @Override
            public IndexDefinition apply(IndexDescriptor rule) {
                try {
                    Label label = DynamicLabel.label(context.keyReadOperations().labelGetName(state, rule.getLabelId()));
                    String propertyKey = context.keyReadOperations().propertyKeyGetName(state, rule.getPropertyKeyId());
                    return new IndexDefinitionImpl(SchemaImpl.this.actions, label, propertyKey, constraintIndex);
                }
                catch (LabelNotFoundKernelException | PropertyKeyIdNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }, indexes), definitions);
    }

    @Override
    public void awaitIndexOnline(IndexDefinition index, long duration, TimeUnit unit) {
        this.assertInTransaction();
        long now = System.currentTimeMillis();
        long timeout = now + unit.toMillis(duration);
        do {
            Schema.IndexState state = this.getIndexState(index);
            switch (state) {
                case ONLINE: {
                    return;
                }
                case FAILED: {
                    throw new IllegalStateException("Index entered a FAILED state. Please see database logs.");
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (System.currentTimeMillis() < timeout);
        throw new IllegalStateException("Expected index to come online within a reasonable time.");
    }

    @Override
    public void awaitIndexesOnline(long duration, TimeUnit unit) {
        this.assertInTransaction();
        long millisLeft = TimeUnit.MILLISECONDS.convert(duration, unit);
        ArrayList<IndexDefinition> onlineIndexes = new ArrayList<IndexDefinition>();
        Iterator<IndexDefinition> iter = this.getIndexes().iterator();
        while (iter.hasNext()) {
            if (millisLeft < 0L) {
                throw new IllegalStateException("Expected all indexes to come online within a reasonable time.Indexes brought online: " + onlineIndexes + ". Indexes not guaranteed to be online: " + IteratorUtil.asCollection(iter));
            }
            IndexDefinition index = iter.next();
            long millisBefore = System.currentTimeMillis();
            this.awaitIndexOnline(index, millisLeft, TimeUnit.MILLISECONDS);
            millisLeft -= System.currentTimeMillis() - millisBefore;
            onlineIndexes.add(index);
        }
    }

    @Override
    public Schema.IndexState getIndexState(IndexDefinition index) {
        this.assertInTransaction();
        StatementOperationParts context = this.ctxProvider.getCtxForReading();
        String propertyKey = IteratorUtil.single(index.getPropertyKeys());
        try (StatementState state = this.ctxProvider.statementForReading();){
            long labelId = context.keyReadOperations().labelGetForName(state, index.getLabel().name());
            long propertyKeyId = context.keyReadOperations().propertyKeyGetForName(state, propertyKey);
            InternalIndexState indexState = context.schemaReadOperations().indexGetState(state, context.schemaReadOperations().indexesGetForLabelAndPropertyKey(state, labelId, propertyKeyId));
            switch (indexState) {
                case POPULATING: {
                    Schema.IndexState indexState2 = Schema.IndexState.POPULATING;
                    return indexState2;
                }
                case ONLINE: {
                    Schema.IndexState indexState3 = Schema.IndexState.ONLINE;
                    return indexState3;
                }
                case FAILED: {
                    Schema.IndexState indexState4 = Schema.IndexState.FAILED;
                    return indexState4;
                }
            }
            try {
                throw new IllegalArgumentException(String.format("Illegal index state %s", new Object[]{indexState}));
            }
            catch (LabelNotFoundKernelException e) {
                throw new NotFoundException(String.format("Label %s not found", index.getLabel().name()));
            }
            catch (PropertyKeyNotFoundException e) {
                throw new NotFoundException(String.format("Property key %s not found", propertyKey));
            }
            catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
                throw new NotFoundException(String.format("No index for label %s on property %s", index.getLabel().name(), propertyKey));
            }
        }
    }

    @Override
    public String getIndexFailure(IndexDefinition index) {
        this.assertInTransaction();
        StatementOperationParts context = this.ctxProvider.getCtxForReading();
        String propertyKey = IteratorUtil.single(index.getPropertyKeys());
        try (StatementState state = this.ctxProvider.statementForReading();){
            long labelId = context.keyReadOperations().labelGetForName(state, index.getLabel().name());
            long propertyKeyId = context.keyReadOperations().propertyKeyGetForName(state, propertyKey);
            IndexDescriptor indexId = context.schemaReadOperations().indexesGetForLabelAndPropertyKey(state, labelId, propertyKeyId);
            String string = context.schemaReadOperations().indexGetFailure(state, indexId);
            return string;
        }
    }

    @Override
    public ConstraintCreator constraintFor(Label label) {
        this.assertInTransaction();
        return new BaseConstraintCreator(this.actions, label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<ConstraintDefinition> getConstraints() {
        this.assertInTransaction();
        StatementOperationParts context = this.ctxProvider.getCtxForReading();
        try (StatementState state = this.ctxProvider.statementForReading();){
            Iterator<UniquenessConstraint> constraints = context.schemaReadOperations().constraintsGetAll(state);
            Iterable<ConstraintDefinition> iterable = this.asConstraintDefinitions(context, state, constraints);
            return iterable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<ConstraintDefinition> getConstraints(Label label) {
        this.assertInTransaction();
        StatementOperationParts context = this.ctxProvider.getCtxForReading();
        try (StatementState state = this.ctxProvider.statementForReading();){
            Iterator<UniquenessConstraint> constraints = context.schemaReadOperations().constraintsGetForLabel(state, context.keyReadOperations().labelGetForName(state, label.name()));
            Iterable<ConstraintDefinition> iterable = this.asConstraintDefinitions(context, state, constraints);
            return iterable;
        }
    }

    private Iterable<ConstraintDefinition> asConstraintDefinitions(final StatementOperationParts context, final StatementState state, Iterator<UniquenessConstraint> constraints) {
        Iterator<ConstraintDefinition> definitions = Iterables.map(new Function<UniquenessConstraint, ConstraintDefinition>(){

            @Override
            public ConstraintDefinition apply(UniquenessConstraint constraint) {
                long labelId = constraint.label();
                try {
                    Label label = DynamicLabel.label(context.keyReadOperations().labelGetName(state, labelId));
                    return new PropertyUniqueConstraintDefinition(SchemaImpl.this.actions, label, context.keyReadOperations().propertyKeyGetName(state, constraint.property()));
                }
                catch (PropertyKeyIdNotFoundException e) {
                    throw new ThisShouldNotHappenError("Mattias", "Couldn't find property name for " + constraint.property(), e);
                }
                catch (LabelNotFoundKernelException e) {
                    throw new ThisShouldNotHappenError("Stefan", "Couldn't find label name for label id " + labelId, e);
                }
            }
        }, constraints);
        return IteratorUtil.asCollection(definitions);
    }

    private void assertInTransaction() {
        this.ctxProvider.assertInTransaction();
    }

    private static class GDBSchemaActions
    implements InternalSchemaActions {
        private final ThreadToStatementContextBridge ctxProvider;

        public GDBSchemaActions(ThreadToStatementContextBridge ctxProvider) {
            this.ctxProvider = ctxProvider;
        }

        @Override
        public IndexDefinition createIndexDefinition(Label label, String propertyKey) {
            StatementOperationParts context = this.ctxProvider.getCtxForWriting();
            try (StatementState state = this.ctxProvider.statementForWriting();){
                long labelId = context.keyWriteOperations().labelGetOrCreateForName(state, label.name());
                long propertyKeyId = context.keyWriteOperations().propertyKeyGetOrCreateForName(state, propertyKey);
                context.schemaWriteOperations().indexCreate(state, labelId, propertyKeyId);
                IndexDefinitionImpl indexDefinitionImpl = new IndexDefinitionImpl(this, label, propertyKey, false);
                return indexDefinitionImpl;
            }
        }

        @Override
        public void dropIndexDefinitions(Label label, String propertyKey) {
            StatementOperationParts context = this.ctxProvider.getCtxForWriting();
            try (StatementState state = this.ctxProvider.statementForWriting();){
                long labelId = context.keyReadOperations().labelGetForName(state, label.name());
                long propertyKeyId = context.keyReadOperations().propertyKeyGetForName(state, propertyKey);
                context.schemaWriteOperations().indexDrop(state, context.schemaReadOperations().indexesGetForLabelAndPropertyKey(state, labelId, propertyKeyId));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ConstraintDefinition createPropertyUniquenessConstraint(Label label, String propertyKey) throws SchemaKernelException {
            StatementOperationParts context = this.ctxProvider.getCtxForWriting();
            try (StatementState state = this.ctxProvider.statementForWriting();){
                long labelId = context.keyWriteOperations().labelGetOrCreateForName(state, label.name());
                long propertyKeyId = context.keyWriteOperations().propertyKeyGetOrCreateForName(state, propertyKey);
                context.schemaWriteOperations().uniquenessConstraintCreate(state, labelId, propertyKeyId);
                PropertyUniqueConstraintDefinition propertyUniqueConstraintDefinition = new PropertyUniqueConstraintDefinition(this, label, propertyKey);
                return propertyUniqueConstraintDefinition;
            }
        }

        @Override
        public void dropPropertyUniquenessConstraint(Label label, String propertyKey) {
            StatementOperationParts context = this.ctxProvider.getCtxForWriting();
            try (StatementState state = this.ctxProvider.statementForWriting();){
                long labelId = context.keyWriteOperations().labelGetOrCreateForName(state, label.name());
                long propertyKeyId = context.keyWriteOperations().propertyKeyGetOrCreateForName(state, propertyKey);
                UniquenessConstraint constraint = new UniquenessConstraint(labelId, propertyKeyId);
                context.schemaWriteOperations().constraintDrop(state, constraint);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getUserMessage(KernelException e) {
            StatementOperationParts context = this.ctxProvider.getCtxForWriting();
            try (StatementState state = this.ctxProvider.statementForReading();){
                String string = e.getUserMessage(new KeyNameLookup(state, context.keyReadOperations()));
                return string;
            }
        }

        @Override
        public void assertInTransaction() {
            this.ctxProvider.assertInTransaction();
        }
    }
}

