/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.SideSelector;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;

public abstract class AbstractSelectorOrderer<T>
implements SideSelector {
    private static final BranchSelector EMPTY_SELECTOR = new BranchSelector(){

        @Override
        public TraversalBranch next(TraversalContext metadata) {
            return null;
        }
    };
    private final BranchSelector[] selectors;
    private final T[] states = new Object[2];
    private int selectorIndex;

    public AbstractSelectorOrderer(BranchSelector startSelector, BranchSelector endSelector) {
        this.selectors = new BranchSelector[]{startSelector, endSelector};
        this.states[0] = this.initialState();
        this.states[1] = this.initialState();
    }

    protected T initialState() {
        return null;
    }

    protected void setStateForCurrentSelector(T state) {
        this.states[this.selectorIndex] = state;
    }

    protected T getStateForCurrentSelector() {
        return this.states[this.selectorIndex];
    }

    protected TraversalBranch nextBranchFromCurrentSelector(TraversalContext metadata, boolean switchIfExhausted) {
        return this.nextBranchFromSelector(metadata, this.selectors[this.selectorIndex], switchIfExhausted);
    }

    protected TraversalBranch nextBranchFromNextSelector(TraversalContext metadata, boolean switchIfExhausted) {
        return this.nextBranchFromSelector(metadata, this.nextSelector(), switchIfExhausted);
    }

    private TraversalBranch nextBranchFromSelector(TraversalContext metadata, BranchSelector selector, boolean switchIfExhausted) {
        TraversalBranch result = selector.next(metadata);
        if (result == null) {
            this.selectors[this.selectorIndex] = EMPTY_SELECTOR;
            if (switchIfExhausted && (result = this.nextSelector().next(metadata)) == null) {
                this.selectors[this.selectorIndex] = EMPTY_SELECTOR;
            }
        }
        return result;
    }

    protected BranchSelector nextSelector() {
        this.selectorIndex = (this.selectorIndex + 1) % 2;
        BranchSelector selector = this.selectors[this.selectorIndex];
        return selector;
    }

    @Override
    public Direction currentSide() {
        return this.selectorIndex == 0 ? Direction.OUTGOING : Direction.INCOMING;
    }
}

