/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.RecordSerializer;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class SchemaStore
extends AbstractDynamicStore
implements Iterable<SchemaRule> {
    public static final String TYPE_DESCRIPTOR = "SchemaStore";
    public static final String VERSION = SchemaStore.buildTypeDescriptorAndVersion("SchemaStore");
    public static final int BLOCK_SIZE = 56;

    public SchemaStore(File fileName, Config conf, IdType idType, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger) {
        super(fileName, conf, idType, idGeneratorFactory, windowPoolFactory, fileSystemAbstraction, stringLogger);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, DynamicRecord record) throws FAILURE {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    public Collection<DynamicRecord> allocateFrom(SchemaRule rule) {
        RecordSerializer serializer = new RecordSerializer();
        serializer = serializer.append(rule);
        return this.allocateRecordsFromBytes(serializer.serialize(), Arrays.asList(this.forceGetRecord(rule.getId())).iterator());
    }

    public Iterator<SchemaRule> loadAll() {
        return new PrefetchingIterator<SchemaRule>(){
            private final long highestId;
            private long currentId;
            private final byte[] scratchData;
            {
                this.highestId = SchemaStore.this.getHighestPossibleIdInUse();
                this.currentId = 1L;
                this.scratchData = SchemaStore.this.newRecordBuffer();
            }

            @Override
            protected SchemaRule fetchNextOrNull() {
                while (this.currentId <= this.highestId) {
                    long id;
                    ++this.currentId;
                    DynamicRecord record = SchemaStore.this.forceGetRecord(id);
                    if (!record.inUse() || !record.isStartRecord()) continue;
                    return SchemaStore.this.getSchemaRule(id, this.scratchData);
                }
                return null;
            }
        };
    }

    @Override
    public Iterator<SchemaRule> iterator() {
        return this.loadAll();
    }

    private byte[] newRecordBuffer() {
        return new byte[this.getRecordSize() * 4];
    }

    private SchemaRule getSchemaRule(long id, byte[] buffer) {
        Collection<DynamicRecord> records = this.getRecords(id);
        ByteBuffer scratchBuffer = SchemaStore.concatData(records, buffer);
        return SchemaRule.Kind.deserialize(id, scratchBuffer);
    }
}

