/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.persistence.EntityIdGenerator;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public abstract class TokenHolder<TOKEN extends Token>
extends LifecycleAdapter {
    private final Map<String, Integer> nameToId = new CopyOnWriteHashMap<String, Integer>();
    private final Map<Integer, TOKEN> idToToken = new CopyOnWriteHashMap<Integer, TOKEN>();
    private final AbstractTransactionManager transactionManager;
    protected final PersistenceManager persistenceManager;
    private final EntityIdGenerator idGenerator;
    private final TokenCreator tokenCreator;

    public TokenHolder(AbstractTransactionManager transactionManager, PersistenceManager persistenceManager, EntityIdGenerator idGenerator, TokenCreator tokenCreator) {
        this.transactionManager = transactionManager;
        this.persistenceManager = persistenceManager;
        this.idGenerator = idGenerator;
        this.tokenCreator = tokenCreator;
    }

    void addTokens(Token ... tokens) {
        HashMap<String, Integer> newNameToId = new HashMap<String, Integer>();
        HashMap newIdToToken = new HashMap();
        for (Token token : tokens) {
            this.addToken(token.name(), token.id(), newNameToId, newIdToToken);
            this.notifyMeOfTokensAdded(token.name(), token.id());
        }
        this.nameToId.putAll(newNameToId);
        this.idToToken.putAll(newIdToToken);
    }

    protected void notifyMeOfTokensAdded(String name, int id) {
    }

    void addToken(String name, int id) {
        this.addToken(name, id, this.nameToId, this.idToToken);
        this.notifyMeOfTokensAdded(name, id);
    }

    void addToken(String name, int id, Map<String, Integer> nameToIdMap, Map<Integer, TOKEN> idToTokenMap) {
        TOKEN token = this.newToken(name, id);
        nameToIdMap.put(name, id);
        idToTokenMap.put(id, token);
    }

    void removeToken(int id) {
        Token token = (Token)this.idToToken.remove(id);
        this.nameToId.remove(token.name());
    }

    public int getOrCreateId(String name) {
        Integer id = this.nameToId.get(name);
        if (id != null) {
            return id;
        }
        id = this.createToken(name);
        return id;
    }

    private synchronized int createToken(String name) {
        Integer id = this.nameToId.get(name);
        if (id != null) {
            return id;
        }
        id = this.tokenCreator.getOrCreate(this.transactionManager, this.idGenerator, this.persistenceManager, name);
        this.addToken(name, id);
        return id;
    }

    public TOKEN getTokenById(int id) throws TokenNotFoundException {
        TOKEN result = this.getTokenByIdOrNull(id);
        if (result == null) {
            throw new TokenNotFoundException("Token for id " + id);
        }
        return result;
    }

    public TOKEN getTokenByIdOrNull(int id) {
        return (TOKEN)((Token)this.idToToken.get(id));
    }

    public boolean hasTokenWithId(int id) {
        return this.idToToken.containsKey(id);
    }

    public final int idOf(TOKEN token) throws TokenNotFoundException {
        return this.getIdByName(((Token)token).name());
    }

    public int getIdByName(String name) throws TokenNotFoundException {
        Integer id = this.nameToId.get(name);
        if (id == null) {
            throw new TokenNotFoundException(name);
        }
        return id;
    }

    public TOKEN getTokenByName(String name) throws TokenNotFoundException {
        Integer id = this.nameToId.get(name);
        if (id == null) {
            throw new TokenNotFoundException(name);
        }
        return (TOKEN)((Token)this.idToToken.get(id));
    }

    public TOKEN getTokenByNameOrNull(String name) {
        Integer id = this.nameToId.get(name);
        return (TOKEN)(id != null ? (Token)this.idToToken.get(id) : null);
    }

    public Iterable<TOKEN> getAllTokens() {
        return this.idToToken.values();
    }

    @Override
    public void stop() {
        this.nameToId.clear();
        this.idToToken.clear();
    }

    protected abstract TOKEN newToken(String var1, int var2);
}

