/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.impl.api.DiffSets;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.state.LabelState;
import org.neo4j.kernel.impl.api.state.NodeState;
import org.neo4j.kernel.impl.api.state.OldTxStateBridge;
import org.neo4j.kernel.impl.persistence.PersistenceManager;

public class TxState {
    private final Map<Long, NodeState> nodeStates = new HashMap<Long, NodeState>();
    private final Map<Long, LabelState> labelStates = new HashMap<Long, LabelState>();
    private final DiffSets<IndexDescriptor> indexChanges = new DiffSets();
    private final DiffSets<IndexDescriptor> constraintIndexChanges = new DiffSets();
    private final DiffSets<UniquenessConstraint> constraintsChanges = new DiffSets();
    private final DiffSets<Long> nodes = new DiffSets();
    private final Map<UniquenessConstraint, Long> createdConstraintIndexes = new HashMap<UniquenessConstraint, Long>();
    private final OldTxStateBridge legacyState;
    private final PersistenceManager persistenceManager;
    private final IdGeneration idGeneration;

    public TxState(OldTxStateBridge legacyState, PersistenceManager legacyTransaction, IdGeneration idGeneration) {
        this.legacyState = legacyState;
        this.persistenceManager = legacyTransaction;
        this.idGeneration = idGeneration;
    }

    public void accept(final Visitor visitor) {
        for (NodeState node : this.nodeStates.values()) {
            DiffSets<Long> labelDiff = node.getLabelDiffSets();
            visitor.visitNodeLabelChanges(node.getId(), labelDiff.getAdded(), labelDiff.getRemoved());
        }
        this.indexChanges.accept(TxState.indexVisitor(visitor, false));
        this.constraintIndexChanges.accept(TxState.indexVisitor(visitor, true));
        this.constraintsChanges.accept(new DiffSets.Visitor<UniquenessConstraint>(){

            @Override
            public void visitAdded(UniquenessConstraint element) {
                visitor.visitAddedConstraint(element, (Long)TxState.this.createdConstraintIndexes.get(element));
            }

            @Override
            public void visitRemoved(UniquenessConstraint element) {
                visitor.visitRemovedConstraint(element);
            }
        });
    }

    private static DiffSets.Visitor<IndexDescriptor> indexVisitor(final Visitor visitor, final boolean forConstraint) {
        return new DiffSets.Visitor<IndexDescriptor>(){

            @Override
            public void visitAdded(IndexDescriptor element) {
                visitor.visitAddedIndex(element, forConstraint);
            }

            @Override
            public void visitRemoved(IndexDescriptor element) {
                visitor.visitRemovedIndex(element, forConstraint);
            }
        };
    }

    public boolean hasChanges() {
        return !this.nodeStates.isEmpty() || !this.labelStates.isEmpty() || !this.nodes.isEmpty() || !this.indexChanges.isEmpty() || !this.constraintsChanges.isEmpty() || this.legacyState.hasChanges();
    }

    public Iterable<NodeState> getNodeStates() {
        return this.nodeStates.values();
    }

    public DiffSets<Long> getLabelStateNodeDiffSets(long labelId) {
        return this.getOrCreateLabelState(labelId).getNodeDiffSets();
    }

    public DiffSets<Long> getNodeStateLabelDiffSets(long nodeId) {
        return this.getOrCreateNodeState(nodeId).getLabelDiffSets();
    }

    public void deleteNode(long nodeId) {
        this.legacyState.deleteNode(nodeId);
        this.nodes.remove(nodeId);
    }

    public boolean nodeIsDeletedInThisTx(long nodeId) {
        return this.nodes.isRemoved(nodeId);
    }

    public boolean nodeIsAddedInThisTx(long nodeId) {
        return this.legacyState.nodeIsAddedInThisTx(nodeId);
    }

    public void addLabelToNode(long labelId, long nodeId) {
        this.getLabelStateNodeDiffSets(labelId).add(nodeId);
        this.getNodeStateLabelDiffSets(nodeId).add(labelId);
        this.persistenceManager.addLabelToNode(labelId, nodeId);
    }

    public void removeLabelFromNode(long labelId, long nodeId) {
        this.getLabelStateNodeDiffSets(labelId).remove(nodeId);
        this.getNodeStateLabelDiffSets(nodeId).remove(labelId);
        this.persistenceManager.removeLabelFromNode(labelId, nodeId);
    }

    public Boolean getLabelState(long nodeId, long labelId) {
        NodeState nodeState = this.getState(this.nodeStates, nodeId, null);
        if (nodeState != null) {
            DiffSets<Long> labelDiff = nodeState.getLabelDiffSets();
            if (labelDiff.isAdded(labelId)) {
                return Boolean.TRUE;
            }
            if (labelDiff.isRemoved(labelId)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public Set<Long> getNodesWithLabelAdded(long labelId) {
        LabelState state = this.getState(this.labelStates, labelId, null);
        return state == null ? Collections.emptySet() : state.getNodeDiffSets().getAdded();
    }

    public DiffSets<Long> getNodesWithLabelChanged(long labelId) {
        LabelState state = this.getState(this.labelStates, labelId, null);
        return state == null ? DiffSets.emptyDiffSets() : state.getNodeDiffSets();
    }

    public void addIndexRule(IndexDescriptor descriptor) {
        this.indexChanges.add(descriptor);
        this.getOrCreateLabelState(descriptor.getLabelId()).indexChanges().add(descriptor);
    }

    public void addConstraintIndexRule(IndexDescriptor descriptor) {
        this.constraintIndexChanges.add(descriptor);
        this.getOrCreateLabelState(descriptor.getLabelId()).constraintIndexChanges().add(descriptor);
    }

    public void dropIndex(IndexDescriptor descriptor) {
        this.indexChanges.remove(descriptor);
        this.getOrCreateLabelState(descriptor.getLabelId()).indexChanges().remove(descriptor);
    }

    public void dropConstraintIndex(IndexDescriptor descriptor) {
        this.constraintIndexChanges.remove(descriptor);
        this.getOrCreateLabelState(descriptor.getLabelId()).constraintIndexChanges().remove(descriptor);
    }

    public DiffSets<IndexDescriptor> getIndexDiffSetsByLabel(long labelId) {
        LabelState labelState = this.getState(this.labelStates, labelId, null);
        return labelState != null ? labelState.indexChanges() : DiffSets.emptyDiffSets();
    }

    public DiffSets<IndexDescriptor> getConstraintIndexDiffSetsByLabel(long labelId) {
        LabelState labelState = this.getState(this.labelStates, labelId, null);
        return labelState != null ? labelState.constraintIndexChanges() : DiffSets.emptyDiffSets();
    }

    public DiffSets<IndexDescriptor> getIndexDiffSets() {
        return this.indexChanges;
    }

    public DiffSets<IndexDescriptor> getConstraintIndexDiffSets() {
        return this.constraintIndexChanges;
    }

    public DiffSets<Long> getNodesWithChangedProperty(long propertyKeyId, Object value) {
        return this.legacyState.getNodesWithChangedProperty(propertyKeyId, value);
    }

    public DiffSets<Long> getDeletedNodes() {
        return this.nodes;
    }

    private LabelState getOrCreateLabelState(long labelId) {
        return this.getState(this.labelStates, labelId, new StateCreator<LabelState>(){

            @Override
            public LabelState newState(long id) {
                return new LabelState(id);
            }
        });
    }

    private NodeState getOrCreateNodeState(long nodeId) {
        return this.getState(this.nodeStates, nodeId, new StateCreator<NodeState>(){

            @Override
            public NodeState newState(long id) {
                return new NodeState(id);
            }
        });
    }

    private <STATE> STATE getState(Map<Long, STATE> states, long id, StateCreator<STATE> creator) {
        STATE result = states.get(id);
        if (result != null) {
            return result;
        }
        if (creator != null) {
            result = creator.newState(id);
            states.put(id, result);
        }
        return result;
    }

    public void addConstraint(UniquenessConstraint constraint, long indexId) {
        this.constraintsChanges.add(constraint);
        this.createdConstraintIndexes.put(constraint, indexId);
        this.getOrCreateLabelState(constraint.label()).constraintsChanges().add(constraint);
    }

    public DiffSets<UniquenessConstraint> constraintsChangesForLabelAndProperty(long labelId, final long propertyKey) {
        return this.getOrCreateLabelState(labelId).constraintsChanges().filterAdded(new Predicate<UniquenessConstraint>(){

            @Override
            public boolean accept(UniquenessConstraint item) {
                return item.property() == propertyKey;
            }
        });
    }

    public DiffSets<UniquenessConstraint> constraintsChangesForLabel(long labelId) {
        return this.getOrCreateLabelState(labelId).constraintsChanges();
    }

    public DiffSets<UniquenessConstraint> constraintsChanges() {
        return this.constraintsChanges;
    }

    public void dropConstraint(UniquenessConstraint constraint) {
        if (this.constraintsChanges.remove(constraint)) {
            this.createdConstraintIndexes.remove(constraint);
        }
        this.constraintsChangesForLabel(constraint.label()).remove(constraint);
    }

    public boolean unRemoveConstraint(UniquenessConstraint constraint) {
        return this.constraintsChanges.unRemove(constraint);
    }

    public Iterable<IndexDescriptor> createdConstraintIndexes() {
        return Iterables.map(new Function<UniquenessConstraint, IndexDescriptor>(){

            @Override
            public IndexDescriptor apply(UniquenessConstraint constraint) {
                return new IndexDescriptor(constraint.label(), constraint.property());
            }
        }, this.createdConstraintIndexes.keySet());
    }

    private static interface StateCreator<STATE> {
        public STATE newState(long var1);
    }

    public static interface Visitor {
        public void visitNodeLabelChanges(long var1, Set<Long> var3, Set<Long> var4);

        public void visitAddedIndex(IndexDescriptor var1, boolean var2);

        public void visitRemovedIndex(IndexDescriptor var1, boolean var2);

        public void visitAddedConstraint(UniquenessConstraint var1, long var2);

        public void visitRemovedConstraint(UniquenessConstraint var1);
    }

    public static interface IdGeneration {
        public long newNodeId();

        public long newRelationshipId();
    }
}

