/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundException;
import org.neo4j.kernel.api.exceptions.TransactionalException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.operations.SchemaStateOperations;
import org.neo4j.kernel.impl.api.CompositeStatementContext;
import org.neo4j.kernel.impl.api.ConstraintCreationKernelException;
import org.neo4j.kernel.impl.api.DiffSets;
import org.neo4j.kernel.impl.api.constraints.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.state.TxState;

public class StateHandlingStatementContext
extends CompositeStatementContext {
    private final TxState state;
    private final StatementContext delegate;
    private final ConstraintIndexCreator constraintIndexCreator;

    public StateHandlingStatementContext(StatementContext actual, SchemaStateOperations schemaOperations, TxState state, ConstraintIndexCreator constraintIndexCreator) {
        super(actual, schemaOperations);
        this.state = state;
        this.delegate = actual;
        this.constraintIndexCreator = constraintIndexCreator;
    }

    @Override
    public void nodeDelete(long nodeId) {
        this.state.deleteNode(nodeId);
    }

    @Override
    public boolean nodeHasLabel(long nodeId, long labelId) throws EntityNotFoundException {
        if (this.state.hasChanges()) {
            if (this.state.nodeIsDeletedInThisTx(nodeId)) {
                return false;
            }
            if (this.state.nodeIsAddedInThisTx(nodeId)) {
                Boolean labelState = this.state.getLabelState(nodeId, labelId);
                return labelState != null && labelState != false;
            }
            Boolean labelState = this.state.getLabelState(nodeId, labelId);
            if (labelState != null) {
                return labelState;
            }
        }
        return this.delegate.nodeHasLabel(nodeId, labelId);
    }

    @Override
    public Iterator<Long> nodeGetLabels(long nodeId) throws EntityNotFoundException {
        if (this.state.nodeIsDeletedInThisTx(nodeId)) {
            return IteratorUtil.emptyIterator();
        }
        if (this.state.nodeIsAddedInThisTx(nodeId)) {
            return this.state.getNodeStateLabelDiffSets(nodeId).getAdded().iterator();
        }
        Iterator<Long> committed = this.delegate.nodeGetLabels(nodeId);
        return this.state.getNodeStateLabelDiffSets(nodeId).apply(committed);
    }

    @Override
    public boolean nodeAddLabel(long nodeId, long labelId) throws EntityNotFoundException {
        if (this.nodeHasLabel(nodeId, labelId)) {
            return false;
        }
        this.state.addLabelToNode(labelId, nodeId);
        return true;
    }

    @Override
    public boolean nodeRemoveLabel(long nodeId, long labelId) throws EntityNotFoundException {
        if (!this.nodeHasLabel(nodeId, labelId)) {
            return false;
        }
        this.state.removeLabelFromNode(labelId, nodeId);
        return true;
    }

    @Override
    public Iterator<Long> nodesGetForLabel(long labelId) {
        Iterator<Long> committed = this.delegate.nodesGetForLabel(labelId);
        if (!this.state.hasChanges()) {
            return committed;
        }
        return this.state.getDeletedNodes().apply(this.state.getNodesWithLabelChanged(labelId).apply(committed));
    }

    @Override
    public IndexDescriptor indexCreate(long labelId, long propertyKey) throws SchemaKernelException {
        IndexDescriptor rule = new IndexDescriptor(labelId, propertyKey);
        this.state.addIndexRule(rule);
        return rule;
    }

    @Override
    public IndexDescriptor uniqueIndexCreate(long labelId, long propertyKey) throws SchemaKernelException {
        IndexDescriptor rule = new IndexDescriptor(labelId, propertyKey);
        this.state.addConstraintIndexRule(rule);
        return rule;
    }

    @Override
    public void indexDrop(IndexDescriptor descriptor) throws DropIndexFailureException {
        this.state.dropIndex(descriptor);
    }

    @Override
    public void uniqueIndexDrop(IndexDescriptor descriptor) throws DropIndexFailureException {
        this.state.dropConstraintIndex(descriptor);
    }

    @Override
    public UniquenessConstraint uniquenessConstraintCreate(long labelId, long propertyKeyId) throws SchemaKernelException, ConstraintCreationKernelException {
        UniquenessConstraint constraint = new UniquenessConstraint(labelId, propertyKeyId);
        if (!this.state.unRemoveConstraint(constraint)) {
            long indexId;
            Iterator<UniquenessConstraint> it = this.delegate.constraintsGetForLabelAndPropertyKey(labelId, propertyKeyId);
            while (it.hasNext()) {
                if (!it.next().equals(labelId, propertyKeyId)) continue;
                return constraint;
            }
            try {
                indexId = this.constraintIndexCreator.createUniquenessConstraintIndex(this, labelId, propertyKeyId);
            }
            catch (TransactionalException e) {
                throw new ConstraintCreationKernelException(constraint, (Throwable)e);
            }
            catch (KernelException e) {
                throw new ConstraintCreationKernelException(constraint, (Throwable)e);
            }
            this.state.addConstraint(constraint, indexId);
        }
        return constraint;
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(long labelId, long propertyKeyId) {
        return this.applyConstraintsDiff(this.delegate.constraintsGetForLabelAndPropertyKey(labelId, propertyKeyId), labelId, propertyKeyId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(long labelId) {
        return this.applyConstraintsDiff(this.delegate.constraintsGetForLabel(labelId), labelId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll() {
        return this.applyConstraintsDiff(this.delegate.constraintsGetAll());
    }

    private Iterator<UniquenessConstraint> applyConstraintsDiff(Iterator<UniquenessConstraint> constraints, long labelId, long propertyKeyId) {
        DiffSets<UniquenessConstraint> diff = this.state.constraintsChangesForLabelAndProperty(labelId, propertyKeyId);
        if (diff != null) {
            return diff.apply(constraints);
        }
        return constraints;
    }

    private Iterator<UniquenessConstraint> applyConstraintsDiff(Iterator<UniquenessConstraint> constraints, long labelId) {
        DiffSets<UniquenessConstraint> diff = this.state.constraintsChangesForLabel(labelId);
        if (diff != null) {
            return diff.apply(constraints);
        }
        return constraints;
    }

    private Iterator<UniquenessConstraint> applyConstraintsDiff(Iterator<UniquenessConstraint> constraints) {
        DiffSets<UniquenessConstraint> diff = this.state.constraintsChanges();
        if (diff != null) {
            return diff.apply(constraints);
        }
        return constraints;
    }

    @Override
    public void constraintDrop(UniquenessConstraint constraint) {
        this.state.dropConstraint(constraint);
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(long labelId, long propertyKey) throws SchemaRuleNotFoundException {
        Iterable<Object> committedRules;
        try {
            committedRules = Iterables.option(this.delegate.indexesGetForLabelAndPropertyKey(labelId, propertyKey));
        }
        catch (SchemaRuleNotFoundException e) {
            committedRules = Collections.emptyList();
        }
        DiffSets<IndexDescriptor> ruleDiffSet = this.state.getIndexDiffSetsByLabel(labelId);
        Iterator<Object> rules = ruleDiffSet.apply(committedRules.iterator());
        IndexDescriptor single = (IndexDescriptor)IteratorUtil.singleOrNull(rules);
        if (single == null) {
            throw new SchemaRuleNotFoundException("Index rule for label:" + labelId + " and property:" + propertyKey + " not found");
        }
        return single;
    }

    @Override
    public InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        if (this.checkIndexState(descriptor, this.state.getIndexDiffSetsByLabel(descriptor.getLabelId()))) {
            return InternalIndexState.POPULATING;
        }
        if (this.checkIndexState(descriptor, this.state.getConstraintIndexDiffSetsByLabel(descriptor.getLabelId()))) {
            return InternalIndexState.POPULATING;
        }
        return this.delegate.indexGetState(descriptor);
    }

    private boolean checkIndexState(IndexDescriptor indexRule, DiffSets<IndexDescriptor> diffSet) throws IndexNotFoundKernelException {
        if (diffSet.isAdded(indexRule)) {
            return true;
        }
        if (diffSet.isRemoved(indexRule)) {
            throw new IndexNotFoundKernelException(String.format("Index for label id %d on property id %d has been dropped in this transaction.", indexRule.getLabelId(), indexRule.getPropertyKeyId()));
        }
        return false;
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(long labelId) {
        return this.state.getIndexDiffSetsByLabel(labelId).apply(this.delegate.indexesGetForLabel(labelId));
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll() {
        return this.state.getIndexDiffSets().apply(this.delegate.indexesGetAll());
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(long labelId) {
        return this.state.getConstraintIndexDiffSetsByLabel(labelId).apply(this.delegate.uniqueIndexesGetForLabel(labelId));
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll() {
        return this.state.getConstraintIndexDiffSets().apply(this.delegate.uniqueIndexesGetAll());
    }

    @Override
    public Iterator<Long> nodesGetFromIndexLookup(IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        DiffSets<Long> diff = this.state.getNodesWithChangedProperty(index.getPropertyKeyId(), value);
        diff = diff.filterAdded(new HasLabelFilter(index.getLabelId()));
        HasPropertyFilter hasPropertyFilter = new HasPropertyFilter(index.getPropertyKeyId(), value);
        Iterator<Long> addedNodesWithLabel = this.state.getNodesWithLabelAdded(index.getLabelId()).iterator();
        diff.addAll(Iterables.filter(hasPropertyFilter, addedNodesWithLabel));
        Set<Long> removedNodesWithLabel = this.state.getNodesWithLabelChanged(index.getLabelId()).getRemoved();
        diff.removeAll(Iterables.filter(hasPropertyFilter, removedNodesWithLabel.iterator()));
        return this.state.getDeletedNodes().apply(diff.apply(this.delegate.nodesGetFromIndexLookup(index, value)));
    }

    private class HasLabelFilter
    implements Predicate<Long> {
        private final long labelId;

        public HasLabelFilter(long labelId) {
            this.labelId = labelId;
        }

        @Override
        public boolean accept(Long nodeId) {
            try {
                return StateHandlingStatementContext.this.nodeHasLabel(nodeId, this.labelId);
            }
            catch (EntityNotFoundException e) {
                return false;
            }
        }
    }

    private class HasPropertyFilter
    implements Predicate<Long> {
        private final Object value;
        private final long propertyKeyId;

        public HasPropertyFilter(long propertyKeyId, Object value) {
            this.value = value;
            this.propertyKeyId = propertyKeyId;
        }

        @Override
        public boolean accept(Long nodeId) {
            try {
                return StateHandlingStatementContext.this.delegate.nodeGetProperty(nodeId, this.propertyKeyId).valueEquals(this.value);
            }
            catch (EntityNotFoundException e) {
                return false;
            }
            catch (PropertyKeyIdNotFoundException e) {
                throw new ThisShouldNotHappenError("Stefan/Jake", "propertyKeyId became invalid during indexQuery");
            }
        }
    }
}

