/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.operations.KeyNameLookup;

public class ConstraintCreationKernelException
extends KernelException {
    private final UniquenessConstraint constraint;

    public ConstraintCreationKernelException(UniquenessConstraint constraint, Throwable cause) {
        super(cause, "Unable to create constraint %s: %s", constraint, cause.getMessage());
        this.constraint = constraint;
    }

    public UniquenessConstraint constraint() {
        return this.constraint;
    }

    @Override
    public String getUserMessage(KeyNameLookup keyNameLookup) {
        String message = "Unable to create " + this.constraint.userDescription(keyNameLookup);
        if (this.getCause() instanceof KernelException) {
            KernelException cause = (KernelException)this.getCause();
            return String.format("%s:%n%s", message, cause.getUserMessage(keyNameLookup));
        }
        return message;
    }
}

