/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.NumberPropertyWithin4Bytes;

final class FloatProperty
extends NumberPropertyWithin4Bytes {
    private final float value;
    private final long propertyKeyId;

    FloatProperty(long propertyKeyId, float value) {
        this.propertyKeyId = propertyKeyId;
        this.value = value;
    }

    @Override
    public long propertyKeyId() {
        return this.propertyKeyId;
    }

    @Override
    boolean hasEqualValue(NumberPropertyWithin4Bytes that) {
        return this.value == ((FloatProperty)that).value;
    }

    @Override
    int valueBits() {
        return Float.floatToIntBits(this.value);
    }

    @Override
    public Number value() {
        return Float.valueOf(this.value);
    }
}

