/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.FullSizeProperty;

final class BigLongProperty
extends FullSizeProperty {
    private final long value;

    BigLongProperty(long propertyKeyId, long value) {
        super(propertyKeyId);
        this.value = value;
    }

    @Override
    public Long value() {
        return this.value;
    }

    @Override
    public int intValue() {
        throw new ClassCastException(String.format("[%s:long] is not small enough to fit into an int.", this.value));
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    int valueHash() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    boolean hasEqualValue(FullSizeProperty that) {
        return this.value == ((BigLongProperty)that).value;
    }
}

